/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.dispatch.DispatchMethodBinder;
import me.ehp246.aufjms.core.dispatch.DispatchMethodParser;
import me.ehp246.aufjms.core.dispatch.ProxyInvocationHandler;
import me.ehp246.aufjms.core.dispatch.RequestDispatchMap;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.lang.Nullable;

public final class ByJmsProxyFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Method, DispatchMethodBinder> methodBinderCache = new ConcurrentHashMap<Method, DispatchMethodBinder>();
    private final JmsDispatchFnProvider dispatchFnProvider;
    private final PropertyResolver propertyResolver;
    private final EnableByJmsConfig enableByJmsConfig;
    private final RequestDispatchMap requestDispatchMap;
    private final DispatchMethodParser methodParser;

    public ByJmsProxyFactory(EnableByJmsConfig enableByJmsConfig, JmsDispatchFnProvider dispatchFnProvider, PropertyResolver propertyResolver, DispatchMethodParser methodParser, @Nullable RequestDispatchMap requestDispatchMap) {
        this.enableByJmsConfig = enableByJmsConfig;
        this.dispatchFnProvider = dispatchFnProvider;
        this.propertyResolver = propertyResolver;
        this.requestDispatchMap = requestDispatchMap;
        this.methodParser = methodParser;
    }

    public <T> T newByJmsProxy(Class<T> proxyInterface) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = proxyInterface::getCanonicalName;
        LOGGER.atDebug().log("Instantiating {}", supplierArray);
        ByJms byJms = proxyInterface.getAnnotation(ByJms.class);
        String toName = this.propertyResolver.resolve(byJms.value().value());
        if (!OneUtil.hasValue(toName)) {
            throw new IllegalArgumentException("Un-supported To: '" + toName + "'");
        }
        At destination = byJms.value().type() == DestinationType.QUEUE ? At.toQueue(toName) : At.toTopic(toName);
        String replyToName = this.propertyResolver.resolve(byJms.replyTo().value());
        At replyTo = OneUtil.hasValue(replyToName) ? (byJms.replyTo().type() == DestinationType.QUEUE ? At.toQueue(replyToName) : At.toTopic(replyToName)) : this.enableByJmsConfig.requestReplyAt();
        Duration requestTimeout = Optional.ofNullable(this.propertyResolver.resolve(byJms.requestTimeout())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(() -> Optional.ofNullable(this.propertyResolver.resolve("${me.ehp246.aufjms.request.timeout:}")).filter(OneUtil::hasValue).map(Duration::parse).orElse(null));
        Duration ttl = Optional.of(this.propertyResolver.resolve(byJms.ttl())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(this.enableByJmsConfig::ttl);
        Duration delay = Optional.of(this.propertyResolver.resolve(byJms.delay())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(this.enableByJmsConfig::delay);
        ByJmsProxyConfig proxyConfig = new ByJmsProxyConfig(destination, replyTo, requestTimeout, ttl, delay, byJms.connectionFactory(), List.of(byJms.properties()));
        JmsDispatchFn dispatchFn = this.dispatchFnProvider.get(byJms.connectionFactory());
        Function<Method, DispatchMethodBinder> binderSupplier = method -> this.methodBinderCache.computeIfAbsent((Method)method, m -> this.methodParser.parse((Method)m, proxyConfig));
        return (T)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)new ProxyInvocationHandler(proxyInterface, dispatchFn, binderSupplier, this.requestDispatchMap));
    }
}

