/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.BodyOf;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.core.dispatch.InvocationDispatchBinder;
import me.ehp246.aufjms.core.reflection.ReflectedProxyMethod;
import me.ehp246.aufjms.core.util.OneUtil;

final class DefaultProxyInvocationBinder
implements InvocationDispatchBinder {
    private final ReflectedProxyMethod reflected;
    private final ByJmsProxyConfig config;
    private final Function<Object[], String> typeFn;
    private final Function<Object[], String> correlIdFn;
    private final Function<Object[], String> groupIdFn;
    private final Function<Object[], Integer> groupSeqFn;
    private final Function<Object[], Duration> ttlFn;
    private final Function<Object[], Duration> delayFn;
    private final Map<Integer, PropertyArg> propArgs;
    private final Map<String, String> propStatic;
    private final int bodyIndex;
    private final BodyOf<?> bodyOf;

    DefaultProxyInvocationBinder(ReflectedProxyMethod reflected, ByJmsProxyConfig config, Function<Object[], String> typeFn, Function<Object[], String> correlIdFn, int bodyIndex, BodyOf<?> bodyAs, Map<Integer, PropertyArg> propArgs, Map<String, String> propStatic, Function<Object[], Duration> ttlFn, Function<Object[], Duration> delayFn, Function<Object[], String> groupIdFn, Function<Object[], Integer> groupSeqFn) {
        this.reflected = reflected;
        this.config = config;
        this.typeFn = typeFn;
        this.correlIdFn = correlIdFn;
        this.ttlFn = ttlFn;
        this.delayFn = delayFn;
        this.groupIdFn = groupIdFn;
        this.groupSeqFn = groupSeqFn;
        this.propArgs = propArgs;
        this.propStatic = propStatic;
        this.bodyIndex = bodyIndex;
        this.bodyOf = bodyAs;
    }

    @Override
    public JmsDispatch apply(Object target, Object[] args) {
        final At to = this.config.to();
        final String type = this.typeFn.apply(args);
        final String correlId = this.correlIdFn == null ? UUID.randomUUID().toString() : this.correlIdFn.apply(args);
        final Duration ttl = this.ttlFn == null ? this.config.ttl() : this.ttlFn.apply(args);
        final Duration delay = this.delayFn == null ? this.config.delay() : this.delayFn.apply(args);
        final String groupId = this.groupIdFn == null ? null : this.groupIdFn.apply(args);
        final int groupSeq = groupId == null || this.groupSeqFn == null ? 0 : this.groupSeqFn.apply(args);
        final HashMap<String, String> properties = new HashMap<String, String>(this.propStatic);
        for (Map.Entry<Integer, PropertyArg> entry : this.propArgs.entrySet()) {
            Integer argIndex = entry.getKey();
            PropertyArg propArg = entry.getValue();
            String propName = propArg.name;
            Class<Map> propType = propArg.type();
            Object arg = args[argIndex];
            if (!OneUtil.hasValue(propName) && !propType.isAssignableFrom(Map.class)) {
                throw new IllegalArgumentException("Un-defined property name on parameter " + this.reflected.getParameter(argIndex));
            }
            if (propType.isAssignableFrom(Map.class)) {
                if (arg == null) continue;
                properties.putAll((Map)arg);
                continue;
            }
            properties.put(propName, (String)arg);
        }
        final Object body = this.bodyIndex == -1 ? null : args[this.bodyIndex];
        return new JmsDispatch(){

            @Override
            public At to() {
                return to;
            }

            @Override
            public String type() {
                return type;
            }

            @Override
            public String correlationId() {
                return correlId;
            }

            @Override
            public Object body() {
                return body;
            }

            @Override
            public BodyOf<?> bodyOf() {
                return DefaultProxyInvocationBinder.this.bodyOf;
            }

            @Override
            public At replyTo() {
                return DefaultProxyInvocationBinder.this.config.replyTo();
            }

            @Override
            public Duration ttl() {
                return ttl;
            }

            @Override
            public String groupId() {
                return groupId;
            }

            @Override
            public int groupSeq() {
                return groupSeq;
            }

            @Override
            public Map<String, Object> properties() {
                return properties;
            }

            @Override
            public Duration delay() {
                return delay;
            }
        };
    }

    public record PropertyArg(String name, Class<?> type) {
    }
}

