/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.spi;

import java.util.Map;
import java.util.Set;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.ThreadContext;

public final class Log4jContext {
    private Log4jContext() {
    }

    public static AutoCloseable set(JmsMsg msg) {
        if (msg == null) {
            return () -> {};
        }
        AutoCloseable closeable = () -> Log4jContext.clear(msg);
        ThreadContext.put((String)MsgContextName.AufJmsMsgFrom.name(), (String)OneUtil.toString(msg.destination()));
        ThreadContext.put((String)MsgContextName.AufJmsMsgType.name(), (String)msg.type());
        ThreadContext.put((String)MsgContextName.AufJmsMsgCorrelationId.name(), (String)msg.correlationId());
        Set<String> propertyNames = msg.propertyNames();
        if (propertyNames == null) {
            return closeable;
        }
        propertyNames.stream().filter(name -> name.startsWith("AufJmsLog4jThreadContext")).forEach(name -> ThreadContext.put((String)name.replaceFirst("AufJmsLog4jThreadContext", ""), (String)msg.property((String)name, String.class)));
        return closeable;
    }

    public static AutoCloseable set(JmsDispatch dispatch) {
        if (dispatch == null) {
            return () -> {};
        }
        AutoCloseable closeable = () -> Log4jContext.clear(dispatch);
        ThreadContext.put((String)DispatchContextName.AufJmsDispatchTo.name(), (String)OneUtil.toString(dispatch.to()));
        ThreadContext.put((String)DispatchContextName.AufJmsDispatchType.name(), (String)dispatch.type());
        ThreadContext.put((String)DispatchContextName.AufJmsDispatchCorrelationId.name(), (String)dispatch.correlationId());
        Map<String, Object> properties = dispatch.properties();
        if (properties == null) {
            return closeable;
        }
        properties.keySet().stream().filter(name -> name.startsWith("AufJmsLog4jThreadContext")).forEach(name -> ThreadContext.put((String)name.replaceFirst("AufJmsLog4jThreadContext", ""), (String)properties.get(name).toString()));
        return closeable;
    }

    public static void clear(JmsMsg msg) {
        if (msg == null) {
            return;
        }
        for (MsgContextName value : MsgContextName.values()) {
            ThreadContext.remove((String)value.name());
        }
        Set<String> propertyNames = msg.propertyNames();
        if (propertyNames == null) {
            return;
        }
        propertyNames.stream().filter(name -> name.startsWith("AufJmsLog4jThreadContext")).forEach(name -> ThreadContext.remove((String)name.replaceFirst("AufJmsLog4jThreadContext", "")));
    }

    public static void clear(JmsDispatch dispatch) {
        if (dispatch == null) {
            return;
        }
        for (DispatchContextName value : DispatchContextName.values()) {
            ThreadContext.remove((String)value.name());
        }
        Map<String, Object> properties = dispatch.properties();
        if (properties == null) {
            return;
        }
        properties.keySet().stream().filter(name -> name.startsWith("AufJmsLog4jThreadContext")).forEach(name -> ThreadContext.remove((String)name.replaceFirst("AufJmsLog4jThreadContext", "")));
    }

    private static enum MsgContextName {
        AufJmsMsgFrom,
        AufJmsMsgCorrelationId,
        AufJmsMsgType,
        AufJmsLog4jThreadContext;

    }

    private static enum DispatchContextName {
        AufJmsDispatchTo,
        AufJmsDispatchCorrelationId,
        AufJmsDispatchType;

    }
}

