/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CompletableFuture;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import me.ehp246.aufjms.core.dispatch.ReplyFutureSupplier;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.jms.listener.SessionAwareMessageListener;

final class ReplyListener
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ReplyFutureSupplier futureSupplier;

    ReplyListener(ReplyFutureSupplier futureSupplier) {
        this.futureSupplier = futureSupplier;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Un-supported message type");
        }
        TextMessage textMessage = (TextMessage)message;
        JmsMsg msg = TextJmsMsg.from(textMessage);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = msg::correlationId;
        supplierArray[1] = msg::type;
        LOGGER.atDebug().withMarker(AufJmsConstants.HEADERS).log("{}, {}", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = msg::text;
        LOGGER.atTrace().withMarker(AufJmsConstants.BODY).log("{}", supplierArray2);
        CompletableFuture<JmsMsg> future = this.futureSupplier.get(msg.correlationId());
        if (future == null) {
            Supplier[] supplierArray3 = new Supplier[1];
            supplierArray3[0] = msg::correlationId;
            LOGGER.atTrace().log("{} not found", supplierArray3);
        } else {
            future.complete(msg);
        }
    }
}

