/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import me.ehp246.aufjms.api.exception.BoundInvocationFailedException;
import me.ehp246.aufjms.api.inbound.BoundInvocable;
import me.ehp246.aufjms.api.inbound.Invocable;
import me.ehp246.aufjms.api.inbound.InvocableBinder;
import me.ehp246.aufjms.api.inbound.InvocableDispatcher;
import me.ehp246.aufjms.api.inbound.InvocationListener;
import me.ehp246.aufjms.api.inbound.InvocationModel;
import me.ehp246.aufjms.api.inbound.Invoked;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.Log4jContext;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.lang.Nullable;

final class DefaultInvocableDispatcher
implements InvocableDispatcher {
    private static final Logger LOGGER = LogManager.getLogger(InvocableDispatcher.class);
    private final Executor executor;
    private final InvocableBinder binder;
    private final List<InvocationListener.OnInvoking> invoking = new ArrayList<InvocationListener.OnInvoking>();
    private final List<InvocationListener.OnCompleted> completed = new ArrayList<InvocationListener.OnCompleted>();
    private final List<InvocationListener.OnFailed> failed = new ArrayList<InvocationListener.OnFailed>();

    public DefaultInvocableDispatcher(InvocableBinder binder, @Nullable List<InvocationListener> listeners, @Nullable Executor executor) {
        this.binder = binder;
        this.executor = executor;
        for (Object listener : listeners == null ? List.of() : listeners) {
            if (listener instanceof InvocationListener.OnInvoking) {
                InvocationListener.OnInvoking invoking = (InvocationListener.OnInvoking)listener;
                this.invoking.add(invoking);
            }
            if (listener instanceof InvocationListener.OnCompleted) {
                InvocationListener.OnCompleted completed = (InvocationListener.OnCompleted)listener;
                this.completed.add(completed);
            }
            if (!(listener instanceof InvocationListener.OnFailed)) continue;
            InvocationListener.OnFailed failed = (InvocationListener.OnFailed)listener;
            this.failed.add(failed);
        }
    }

    @Override
    public void dispatch(Invocable invocable, JmsMsg msg) {
        Runnable runnable = () -> {
            Object bound;
            try {
                bound = this.binder.bind(invocable, msg);
                this.invoking.forEach(arg_0 -> DefaultInvocableDispatcher.lambda$dispatch$0((BoundInvocable)bound, arg_0));
                Invoked outcome = bound.invoke();
                if (outcome instanceof Invoked.Failed) {
                    Invoked.Failed failed = (Invoked.Failed)outcome;
                    for (InvocationListener.OnFailed listener2 : this.failed) {
                        try {
                            listener2.onFailed(failed);
                        }
                        catch (Exception e) {
                            failed.thrown().addSuppressed(e);
                        }
                    }
                    Throwable patt3252$temp = failed.thrown();
                    if (patt3252$temp instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)patt3252$temp;
                        throw re;
                    }
                    throw new BoundInvocationFailedException(failed.thrown());
                }
                Invoked.Completed completed = (Invoked.Completed)outcome;
                this.completed.forEach(listener -> listener.onCompleted(completed));
            }
            catch (Throwable throwable) {
                try {
                    Invocable invocable2 = invocable;
                    if (invocable2 != null) {
                        invocable2.close();
                    }
                }
                catch (Exception e) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = e::getMessage;
                    LOGGER.atWarn().withThrowable((Throwable)e).withMarker(AufJmsConstants.EXCEPTION).log("Ignored: {}", supplierArray);
                }
                throw throwable;
            }
            try {
                bound = invocable;
                if (bound != null) {
                    bound.close();
                }
            }
            catch (Exception e) {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = e::getMessage;
                LOGGER.atWarn().withThrowable((Throwable)e).withMarker(AufJmsConstants.EXCEPTION).log("Ignored: {}", supplierArray);
            }
        };
        if (this.executor == null || invocable.invocationModel() == InvocationModel.INLINE) {
            runnable.run();
        } else {
            this.executor.execute(() -> {
                try (AutoCloseable closeable = Log4jContext.set(msg);){
                    runnable.run();
                }
                catch (Exception e) {
                    Supplier[] supplierArray = new Supplier[1];
                    supplierArray[0] = e::getMessage;
                    LOGGER.atWarn().withThrowable((Throwable)e).withMarker(AufJmsConstants.EXCEPTION).log("Ignored: {}", supplierArray);
                }
            });
        }
    }

    private static /* synthetic */ void lambda$dispatch$0(BoundInvocable bound, InvocationListener.OnInvoking listener) {
        listener.onInvoking(bound);
    }
}

