/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.jms;

import jakarta.jms.JMSContext;
import java.util.HashMap;
import java.util.Map;

public final class JmsDispatchContext {
    private static final ThreadLocal<JMSContext> localContext = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<Map<String, Object>> localPropertyMap = ThreadLocal.withInitial(HashMap::new);

    private JmsDispatchContext() {
    }

    public static AutoCloseable setProperties(Map<String, Object> map) {
        localPropertyMap.set(map);
        return JmsDispatchContext.closeable();
    }

    public static Map<String, Object> properties() {
        return localPropertyMap.get();
    }

    public static AutoCloseable setJmsContext(JMSContext jmsContext) {
        localContext.set(jmsContext);
        return JmsDispatchContext.closeable();
    }

    public static JMSContext jmsContext() {
        return localContext.get();
    }

    public static void remove() {
        localContext.remove();
        localPropertyMap.remove();
    }

    public static void close() {
        JMSContext jmsContext = localContext.get();
        JmsDispatchContext.remove();
        if (jmsContext != null) {
            jmsContext.close();
        }
    }

    public static AutoCloseable closeable() {
        return JmsDispatchContext::close;
    }
}

