/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import com.fasterxml.jackson.annotation.JsonView;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDelay;
import me.ehp246.aufjms.api.annotation.OfGroupId;
import me.ehp246.aufjms.api.annotation.OfGroupSeq;
import me.ehp246.aufjms.api.annotation.OfLog4jContext;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfTtl;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.exception.JmsDispatchException;
import me.ehp246.aufjms.api.jms.BodyOf;
import me.ehp246.aufjms.api.jms.FromJson;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.dispatch.DefaultProxyInvocationBinder;
import me.ehp246.aufjms.core.dispatch.DispatchMethodBinder;
import me.ehp246.aufjms.core.dispatch.DispatchMethodParser;
import me.ehp246.aufjms.core.dispatch.InvocationDispatchBinder;
import me.ehp246.aufjms.core.dispatch.InvocationReturnBinder;
import me.ehp246.aufjms.core.reflection.ReflectedMethod;
import me.ehp246.aufjms.core.reflection.ReflectedParameter;
import me.ehp246.aufjms.core.reflection.ReflectedType;
import me.ehp246.aufjms.core.util.OneUtil;
import org.apache.logging.log4j.ThreadContext;

public final class DefaultDispatchMethodParser
implements DispatchMethodParser {
    private static final Set<Class<? extends Annotation>> PARAMETER_ANNOTATIONS = Set.of(OfType.class, OfProperty.class, OfTtl.class, OfDelay.class, OfCorrelationId.class);
    private final PropertyResolver propertyResolver;
    private final FromJson fromJson;

    DefaultDispatchMethodParser(PropertyResolver propertyResolver, FromJson fromJson) {
        this.propertyResolver = propertyResolver;
        this.fromJson = fromJson;
    }

    @Override
    public DispatchMethodBinder parse(Method method, ByJmsProxyConfig config) {
        ReflectedMethod reflected = new ReflectedMethod(method);
        return new DispatchMethodBinder(this.parseInvocationBinder(reflected, config), this.parseReturnBinder(reflected, config));
    }

    private InvocationDispatchBinder parseInvocationBinder(ReflectedMethod reflected, ByJmsProxyConfig config) {
        Function typeFn = reflected.allParametersWith(OfType.class).stream().findFirst().map(p -> args -> (String)args[p.index()]).orElseGet(() -> reflected.findOnMethodUp(OfType.class).map(an -> args -> an.value()).orElseGet(() -> args -> OneUtil.firstUpper(reflected.method().getName())));
        Function correlIdFn = reflected.allParametersWith(OfCorrelationId.class).stream().findFirst().map(p -> {
            int index = p.index();
            return args -> (String)args[index];
        }).orElse(null);
        Function ttlFn = reflected.allParametersWith(OfTtl.class).stream().findFirst().map(p -> args -> (Duration)args[p.index()]).orElseGet(() -> reflected.findOnMethodUp(OfTtl.class).map(a -> args -> Duration.parse(this.propertyResolver.resolve(a.value()))).orElse(null));
        Function delayFn = reflected.allParametersWith(OfDelay.class).stream().findFirst().map(p -> {
            Class<Object> type = p.parameter().getType();
            if (type.isAssignableFrom(String.class)) {
                return args -> {
                    Object delayArg = args[p.index()];
                    if (delayArg == null) {
                        return null;
                    }
                    return Duration.parse((String)delayArg);
                };
            }
            if (type.isAssignableFrom(Duration.class)) {
                return args -> (Duration)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported Delay type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElseGet(() -> reflected.findOnMethodUp(OfDelay.class).map(a -> {
            Duration parsed = Duration.parse(this.propertyResolver.resolve(a.value()));
            return args -> parsed;
        }).orElse(null));
        Function groupIdFn = reflected.allParametersWith(OfGroupId.class).stream().findFirst().map(p -> {
            Class<String> type = p.parameter().getType();
            if (type.isAssignableFrom(String.class)) {
                return args -> (String)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported GroupId type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElseGet(() -> reflected.findOnMethodUp(OfGroupId.class).map(a -> {
            String parsed = this.propertyResolver.resolve(a.value());
            return args -> parsed;
        }).orElse(null));
        Function groupSeqFn = reflected.allParametersWith(OfGroupSeq.class).stream().findFirst().map(p -> {
            Class<Integer> type = p.parameter().getType();
            if (type == Integer.TYPE || type.isAssignableFrom(Integer.class)) {
                return args -> (Integer)args[p.index()];
            }
            throw new IllegalArgumentException("Un-supported GroupSeq type '" + type.getName() + "' on '" + reflected.method().toString() + "'");
        }).orElse(null);
        Integer bodyParamIndex = reflected.firstPayloadParameter(PARAMETER_ANNOTATIONS).map(ReflectedParameter::index).orElse(-1);
        BodyOf bodyOf = Optional.ofNullable(bodyParamIndex == -1 ? null : reflected.getParameter(bodyParamIndex)).map(parameter -> new BodyOf(Optional.ofNullable(parameter.getAnnotation(JsonView.class)).map(JsonView::value).filter(OneUtil::hasValue).map(views -> views[0]).orElse(null), parameter.getType())).orElse(null);
        HashMap<String, Function<Object[], String>> log4jContextBinders = new HashMap<String, Function<Object[], String>>();
        log4jContextBinders.putAll(reflected.allParametersWith(OfLog4jContext.class).stream().filter(p -> p.parameter().getAnnotation(OfLog4jContext.class).op() == OfLog4jContext.OP.Default).collect(Collectors.toMap(p -> {
            String name = p.parameter().getAnnotation(OfLog4jContext.class).value();
            return OneUtil.hasValue(name) ? name : p.parameter().getName();
        }, p -> {
            int index = p.index();
            return args -> args[index] == null ? null : "" + args[index];
        }, (l, r) -> r)));
        if (bodyParamIndex >= 0 && reflected.getParameter(bodyParamIndex).getAnnotation(OfLog4jContext.class) != null) {
            Parameter bodyParam = reflected.getParameter(bodyParamIndex);
            OfLog4jContext ofLog4jContext = bodyParam.getAnnotation(OfLog4jContext.class);
            switch (ofLog4jContext.op()) {
                case Introspect: {
                    String bodyParamContextName = ofLog4jContext.value();
                    Map<String, Function> bodyFieldBinders = new ReflectedType(bodyParam.getType()).streamSuppliersWith(OfLog4jContext.class).filter(p -> p.getAnnotation(OfLog4jContext.class).op() == OfLog4jContext.OP.Default).collect(Collectors.toMap(m -> bodyParamContextName + Optional.of(m.getAnnotation(OfLog4jContext.class).value()).filter(OneUtil::hasValue).orElseGet(() -> m.getName()), Function.identity(), (l, r) -> r)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                        Method m = (Method)entry.getValue();
                        return args -> {
                            Object body = args[bodyParamIndex];
                            if (body == null) {
                                return null;
                            }
                            try {
                                Object ret = m.invoke(body, new Object[0]);
                                return ret == null ? null : "" + ret;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        };
                    }));
                    log4jContextBinders.putAll(bodyFieldBinders);
                    break;
                }
                default: {
                    log4jContextBinders.put(Optional.ofNullable(bodyParam.getAnnotation(OfLog4jContext.class)).map(OfLog4jContext::value).filter(OneUtil::hasValue).orElseGet(bodyParam::getName), args -> args[bodyParamIndex] == null ? null : "" + args[bodyParamIndex]);
                }
            }
        }
        return new DefaultProxyInvocationBinder(reflected, config, typeFn, correlIdFn, bodyParamIndex, bodyOf, this.propArgs(reflected), this.propStatic(reflected, config), ttlFn, delayFn, groupIdFn, groupSeqFn, log4jContextBinders.isEmpty() ? null : log4jContextBinders);
    }

    private InvocationReturnBinder parseReturnBinder(ReflectedMethod reflected, ByJmsProxyConfig config) {
        if (reflected.returnsVoid()) {
            return dispatch -> null;
        }
        BodyOf bodyOf = new BodyOf(reflected.method().getReturnType());
        Duration requestTimeout = config.requestTimeout();
        return (jmsDispatch, replyFuture) -> {
            Optional.ofNullable(jmsDispatch.log4jContext()).ifPresent(ThreadContext::putAll);
            try {
                JmsMsg msg;
                try {
                    msg = requestTimeout == null ? (JmsMsg)replyFuture.get() : (JmsMsg)replyFuture.get(requestTimeout.toSeconds(), TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (reflected.isOnThrows(e.getClass())) {
                        throw e;
                    }
                    throw new JmsDispatchException(e);
                }
                Object t = this.fromJson.apply(msg.text(), bodyOf);
                return t;
            }
            finally {
                Optional.ofNullable(jmsDispatch.log4jContext()).map(Map::keySet).ifPresent(ThreadContext::removeAll);
            }
        };
    }

    private Map<String, String> propStatic(ReflectedMethod reflected, ByJmsProxyConfig config) {
        List<String> properties = config.properties();
        if ((properties.size() & 1) != 0) {
            throw new IllegalArgumentException("Properties should be in name/value pairs on " + reflected.method().getDeclaringClass());
        }
        HashMap<String, String> propStatic = new HashMap<String, String>();
        for (int i = 0; i < properties.size(); i += 2) {
            String key = properties.get(i);
            if (propStatic.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate '" + properties.get(i) + " on " + reflected.method().getDeclaringClass());
            }
            propStatic.put(key, this.propertyResolver.resolve(properties.get(i + 1)));
        }
        return propStatic;
    }

    private Map<Integer, DefaultProxyInvocationBinder.PropertyArg> propArgs(ReflectedMethod reflected) {
        HashMap<Integer, DefaultProxyInvocationBinder.PropertyArg> propArgs = new HashMap<Integer, DefaultProxyInvocationBinder.PropertyArg>();
        for (ReflectedParameter p : reflected.allParametersWith(OfProperty.class)) {
            Parameter parameter = p.parameter();
            propArgs.put(p.index(), new DefaultProxyInvocationBinder.PropertyArg(OneUtil.getIfBlank(parameter.getAnnotation(OfProperty.class).value(), () -> OneUtil.firstUpper(parameter.getName())), parameter.getType()));
        }
        return propArgs;
    }
}

