/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public final class DispatchLogger
implements DispatchListener.OnDispatch,
DispatchListener.PreSend,
DispatchListener.PostSend,
DispatchListener.OnException {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void onDispatch(JmsDispatch dispatch) {
        if (dispatch == null) {
            return;
        }
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = dispatch::correlationId;
        supplierArray[1] = dispatch::to;
        supplierArray[2] = dispatch::type;
        LOGGER.atInfo().withMarker(AufJmsConstants.HEADERS).log("{}, {}, {}", supplierArray);
    }

    @Override
    public void preSend(JmsDispatch dispatch, JmsMsg msg) {
        if (dispatch == null || msg == null) {
            return;
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = dispatch::properties;
        LOGGER.atTrace().withMarker(AufJmsConstants.PROPERTIES).log("{}", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = msg::text;
        LOGGER.atTrace().withMarker(AufJmsConstants.BODY).log("{}", supplierArray2);
    }

    @Override
    public void postSend(JmsDispatch dispatch, JmsMsg msg) {
    }

    @Override
    public void onException(JmsDispatch dispatch, JmsMsg msg, Exception e) {
        if (e == null) {
            return;
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = e::getMessage;
        LOGGER.atTrace().withThrowable((Throwable)e).withMarker(AufJmsConstants.EXCEPTION).log("{}", supplierArray);
    }
}

