/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.dispatch;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.exception.JmsDispatchFailedException;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtQueue;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsDispatchContext;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.jms.ToJson;
import me.ehp246.aufjms.api.spi.MsgMDC;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import me.ehp246.aufjms.core.util.OneUtil;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultDispatchFn
implements JmsDispatchFn {
    private final Logger LOGGER = LoggerFactory.getLogger((String)JmsDispatchFn.class.getName());
    private final ToJson toJson;
    private final ConnectionFactory connectionFactory;
    private final JMSContext jmsContext;
    private final List<DispatchListener.OnDispatch> onDispatchs = new ArrayList<DispatchListener.OnDispatch>();
    private final List<DispatchListener.PreSend> preSends = new ArrayList<DispatchListener.PreSend>();
    private final List<DispatchListener.PostSend> postSends = new ArrayList<DispatchListener.PostSend>();
    private final List<DispatchListener.OnException> onExs = new ArrayList<DispatchListener.OnException>();

    public DefaultDispatchFn(ConnectionFactory connectionFactory, ToJson toJson, List<DispatchListener> dispatchListeners) {
        this.toJson = Objects.requireNonNull(toJson);
        this.connectionFactory = Objects.requireNonNull(connectionFactory);
        this.jmsContext = null;
        this.initListeners(dispatchListeners);
    }

    public DefaultDispatchFn(JMSContext jmsContex, ToJson toJson, List<DispatchListener> dispatchListeners) {
        this.toJson = Objects.requireNonNull(toJson);
        this.connectionFactory = null;
        this.jmsContext = Objects.requireNonNull(jmsContex);
        this.initListeners(dispatchListeners);
    }

    public DefaultDispatchFn(JMSContext jmsContex, ToJson toJson) {
        this.toJson = Objects.requireNonNull(toJson);
        this.connectionFactory = null;
        this.jmsContext = Objects.requireNonNull(jmsContex);
    }

    private void initListeners(List<DispatchListener> dispatchListeners) {
        for (Object listener : dispatchListeners == null ? List.of() : dispatchListeners) {
            if (listener instanceof DispatchListener.OnDispatch) {
                DispatchListener.OnDispatch onDispatch = (DispatchListener.OnDispatch)listener;
                this.onDispatchs.add(onDispatch);
            }
            if (listener instanceof DispatchListener.PreSend) {
                DispatchListener.PreSend preSend = (DispatchListener.PreSend)listener;
                this.preSends.add(preSend);
            }
            if (listener instanceof DispatchListener.PostSend) {
                DispatchListener.PostSend postSend = (DispatchListener.PostSend)listener;
                this.postSends.add(postSend);
            }
            if (!(listener instanceof DispatchListener.OnException)) continue;
            DispatchListener.OnException onEx = (DispatchListener.OnException)listener;
            this.onExs.add(onEx);
        }
    }

    @Override
    public JmsMsg send(JmsDispatch dispatch) {
        Objects.requireNonNull(dispatch);
        MsgMDC.set(dispatch);
        JMSContext localContext = null;
        TextMessage message = null;
        JmsMsg msg = null;
        try {
            Map.Entry entry2;
            for (DispatchListener.OnDispatch onDispatch : this.onDispatchs) {
                onDispatch.onDispatch(dispatch);
            }
            localContext = this.jmsContext == null ? this.connectionFactory.createContext() : this.jmsContext;
            message = localContext.createTextMessage();
            msg = TextJmsMsg.from(message);
            HashMap properties = new HashMap(Optional.ofNullable(dispatch.properties()).orElseGet(Map::of));
            for (Map.Entry entry2 : Optional.ofNullable(JmsDispatchContext.properties()).orElseGet(Map::of).entrySet()) {
                properties.putIfAbsent((String)entry2.getKey(), entry2.getValue());
            }
            for (Map.Entry entry2 : properties.entrySet()) {
                String string = (String)entry2.getKey();
                if (AufJmsConstants.RESERVED_PROPERTIES.contains(string)) {
                    throw new IllegalArgumentException("Un-supported property name '" + string + "'");
                }
                message.setObjectProperty(string, entry2.getValue());
            }
            message.setJMSType(dispatch.type());
            message.setJMSCorrelationID(dispatch.correlationId());
            if (dispatch.groupId() != null && !dispatch.groupId().isBlank()) {
                message.setStringProperty("JMSXGroupID", dispatch.groupId());
                message.setIntProperty("JMSXGroupSeq", dispatch.groupSeq());
            }
            message.setJMSReplyTo(this.toJMSDestintation(localContext, dispatch.replyTo()));
            message.setText(this.toPayload(dispatch));
            JMSProducer jMSProducer = localContext.createProducer().setDeliveryDelay(Optional.ofNullable(dispatch.delay()).map(Duration::toMillis).orElse(0L).longValue()).setTimeToLive(Optional.ofNullable(dispatch.ttl()).map(Duration::toMillis).orElse(0L).longValue());
            for (DispatchListener.PreSend preSend : this.preSends) {
                preSend.preSend(dispatch, msg);
            }
            jMSProducer.send(this.toJMSDestintation(localContext, dispatch.to()), (Message)message);
            for (DispatchListener.PostSend postSend : this.postSends) {
                try {
                    postSend.postSend(dispatch, msg);
                }
                catch (Exception e) {
                    this.LOGGER.atTrace().setCause((Throwable)e).setMessage("Listener {} failed, ignoring: {}").addArgument((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/Object;)((DispatchListener.PostSend)postSend)).addArgument(e::getMessage).log();
                }
            }
            entry2 = msg;
            return entry2;
        }
        catch (Exception e) {
            for (DispatchListener.OnException listener : this.onExs) {
                try {
                    listener.onException(dispatch, msg, e);
                }
                catch (Exception exception) {
                    this.LOGGER.atTrace().setCause((Throwable)exception).setMessage("Listener {} failed, ignoring: {}").addArgument((Supplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/Object;)((DispatchListener.OnException)listener)).addArgument(exception::getMessage).log();
                }
            }
            throw new JmsDispatchFailedException("Dispatch failed, CorrelationId=" + dispatch.correlationId() + ", " + e.getMessage(), e);
        }
        finally {
            if (this.jmsContext == null && localContext != null) {
                try {
                    localContext.close();
                }
                catch (Exception e) {
                    this.LOGGER.atTrace().setCause((Throwable)e).setMessage("JMSCOntext close failed, ignoring: {}").addArgument(e::getMessage).log();
                }
            }
            MsgMDC.clear(dispatch);
        }
    }

    private String toPayload(JmsDispatch dispatch) {
        Object body = dispatch.body();
        if (body == null) {
            return null;
        }
        if (body instanceof Supplier) {
            Supplier supplier = (Supplier)body;
            return Optional.ofNullable(supplier.get()).map(Object::toString).orElse(null);
        }
        return this.toJson.apply(body, dispatch.bodyOf());
    }

    private Destination toJMSDestintation(JMSContext jmsContext, At to) {
        if (to == null || !OneUtil.hasValue(to.name())) {
            return null;
        }
        return to instanceof AtQueue ? jmsContext.createQueue(to.name()) : jmsContext.createTopic(to.name());
    }
}

