/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.ehp246.aufjms.api.annotation.ByJms;
import me.ehp246.aufjms.api.dispatch.ByJmsProxyConfig;
import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.DestinationType;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.PropertyResolver;
import me.ehp246.aufjms.core.dispatch.DispatchMethodBinder;
import me.ehp246.aufjms.core.dispatch.DispatchMethodParser;
import me.ehp246.aufjms.core.dispatch.InvocationReturnBinder;
import me.ehp246.aufjms.core.dispatch.LocalReturnBinder;
import me.ehp246.aufjms.core.dispatch.RemoteReturnBinder;
import me.ehp246.aufjms.core.dispatch.RequestDispatchMap;
import me.ehp246.aufjms.core.util.OneUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.lang.Nullable;

public final class ByJmsProxyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByJmsProxyFactory.class);
    private final Map<Method, DispatchMethodBinder> methodBinderCache = new ConcurrentHashMap<Method, DispatchMethodBinder>();
    private final JmsDispatchFnProvider dispatchFnProvider;
    private final PropertyResolver propertyResolver;
    private final EnableByJmsConfig enableByJmsConfig;
    private final RequestDispatchMap requestDispatchMap;
    private final DispatchMethodParser methodParser;

    public ByJmsProxyFactory(EnableByJmsConfig enableByJmsConfig, JmsDispatchFnProvider dispatchFnProvider, PropertyResolver propertyResolver, DispatchMethodParser methodParser, @Nullable RequestDispatchMap requestDispatchMap) {
        this.enableByJmsConfig = enableByJmsConfig;
        this.dispatchFnProvider = dispatchFnProvider;
        this.propertyResolver = propertyResolver;
        this.requestDispatchMap = requestDispatchMap;
        this.methodParser = methodParser;
    }

    public <T> T newByJmsProxy(Class<T> proxyInterface) {
        LOGGER.atDebug().setMessage("Instantiating {}").addArgument(proxyInterface::getCanonicalName).log();
        ByJms byJms = proxyInterface.getAnnotation(ByJms.class);
        String toName = this.propertyResolver.resolve(byJms.value().value());
        if (!OneUtil.hasValue(toName)) {
            throw new IllegalArgumentException("Un-supported To: '" + toName + "'");
        }
        At destination = byJms.value().type() == DestinationType.QUEUE ? At.toQueue(toName) : At.toTopic(toName);
        String replyToName = this.propertyResolver.resolve(byJms.replyTo().value());
        At replyTo = OneUtil.hasValue(replyToName) ? (byJms.replyTo().type() == DestinationType.QUEUE ? At.toQueue(replyToName) : At.toTopic(replyToName)) : this.enableByJmsConfig.requestReplyAt();
        Duration requestTimeout = Optional.ofNullable(this.propertyResolver.resolve(byJms.requestTimeout())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(() -> Optional.ofNullable(this.propertyResolver.resolve("${me.ehp246.aufjms.request.timeout:}")).filter(OneUtil::hasValue).map(Duration::parse).orElse(null));
        Duration ttl = Optional.of(this.propertyResolver.resolve(byJms.ttl())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(this.enableByJmsConfig::ttl);
        Duration delay = Optional.of(this.propertyResolver.resolve(byJms.delay())).filter(OneUtil::hasValue).map(Duration::parse).orElseGet(this.enableByJmsConfig::delay);
        ByJmsProxyConfig proxyConfig = new ByJmsProxyConfig(destination, replyTo, requestTimeout, ttl, delay, byJms.connectionFactory(), List.of(byJms.properties()));
        JmsDispatchFn dispatchFn = this.dispatchFnProvider.get(byJms.connectionFactory());
        int hashCode = new Object().hashCode();
        return (T)Proxy.newProxyInstance(proxyInterface.getClassLoader(), new Class[]{proxyInterface}, (proxy, method, args) -> {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return hashCode;
            }
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.isDefault()) {
                return MethodHandles.privateLookupIn(proxyInterface, MethodHandles.lookup()).findSpecial(proxyInterface, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), proxyInterface).bindTo(proxy).invokeWithArguments(args);
            }
            DispatchMethodBinder methodBinder = this.methodBinderCache.computeIfAbsent(method, m -> this.methodParser.parse((Method)m, proxyConfig));
            JmsDispatch jmsDispatch = methodBinder.invocationBinder().apply(proxy, args);
            InvocationReturnBinder returnBinder = methodBinder.returnBinder();
            Optional.ofNullable(jmsDispatch.mdc()).orElseGet(Map::of).entrySet().stream().forEach(e -> MDC.put((String)((String)e.getKey()), (String)((String)e.getValue())));
            try {
                Object object;
                CompletableFuture<JmsMsg> futureMsg = returnBinder instanceof RemoteReturnBinder ? this.requestDispatchMap.add(jmsDispatch.correlationId()) : null;
                dispatchFn.send(jmsDispatch);
                if (futureMsg == null) {
                    Object object2 = ((LocalReturnBinder)returnBinder).apply(jmsDispatch);
                    return object2;
                }
                try {
                    object = ((RemoteReturnBinder)returnBinder).apply(jmsDispatch, futureMsg);
                    this.requestDispatchMap.remove(jmsDispatch.correlationId());
                }
                catch (Throwable throwable) {
                    this.requestDispatchMap.remove(jmsDispatch.correlationId());
                    throw throwable;
                }
                return object;
            }
            finally {
                Optional.ofNullable(jmsDispatch.mdc()).orElseGet(Map::of).entrySet().stream().forEach(e -> MDC.remove((String)((String)e.getKey())));
            }
        });
    }
}

