/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import me.ehp246.aufjms.api.dispatch.EnableByJmsConfig;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtTopic;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.core.dispatch.ReplyFutureSupplier;
import me.ehp246.aufjms.core.dispatch.ReplyListener;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;

final class ReplyListenerConfigurer
implements JmsListenerConfigurer {
    private final ConnectionFactoryProvider cfProvider;
    private final EnableByJmsConfig byJmsConfig;
    private final ReplyFutureSupplier futureSupplier;

    public ReplyListenerConfigurer(ConnectionFactoryProvider cfProvider, EnableByJmsConfig byJmsConfig, ReplyFutureSupplier futureSupplier) {
        this.cfProvider = cfProvider;
        this.byJmsConfig = byJmsConfig;
        this.futureSupplier = futureSupplier;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        final At dispatchReplyAt = this.byJmsConfig.requestReplyAt();
        if (dispatchReplyAt == null) {
            return;
        }
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(this.cfProvider.get(""));
        factory.setSessionTransacted(Boolean.valueOf(true));
        factory.setSessionAcknowledgeMode(Integer.valueOf(0));
        registrar.registerEndpoint(new JmsListenerEndpoint(){

            public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                container.setBeanName("");
                container.setDestinationName(dispatchReplyAt.name());
                container.setPubSubDomain(dispatchReplyAt instanceof AtTopic);
                container.setupMessageListener((Object)new ReplyListener(ReplyListenerConfigurer.this.futureSupplier));
            }

            public String getId() {
                return ReplyListener.class.getSimpleName() + "@" + String.valueOf(dispatchReplyAt);
            }
        }, (JmsListenerContainerFactory)factory);
    }
}

