/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.provider.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.ehp246.aufjms.api.jms.BodyOf;
import me.ehp246.aufjms.api.jms.FromJson;
import me.ehp246.aufjms.api.jms.ToJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonByObjectMapper
implements FromJson,
ToJson {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonByObjectMapper.class);
    private final ObjectMapper objectMapper;

    public JsonByObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public String apply(Object value, BodyOf<?> valueInfo) {
        if (value == null) {
            return null;
        }
        Class<?> type = valueInfo == null ? value.getClass() : valueInfo.first();
        Class<?> view = valueInfo == null ? null : valueInfo.view();
        try {
            if (view == null) {
                return this.objectMapper.writerFor(type).writeValueAsString(value);
            }
            return this.objectMapper.writerFor(type).withView(view).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T apply(String json, BodyOf<T> descriptor) {
        BodyOf<Object> bodyOf = descriptor = descriptor == null ? new BodyOf<Object>(Object.class) : descriptor;
        if (json == null || json.isBlank()) {
            return null;
        }
        Class<?> type = Objects.requireNonNull(descriptor.reifying().get(0));
        List<Class<?>> reifying = descriptor.reifying();
        ObjectReader reader = Optional.ofNullable(descriptor.view()).map(view -> this.objectMapper.readerWithView(view)).orElseGet(() -> ((ObjectMapper)this.objectMapper).reader());
        try {
            if (reifying.size() == 1) {
                return (T)reader.forType(type).readValue(json);
            }
            TypeFactory typeFactory = this.objectMapper.getTypeFactory();
            ArrayList types = new ArrayList(reifying);
            int size = types.size();
            JavaType javaType = typeFactory.constructParametricType(types.get(size - 2), new Class[]{types.get(size - 1)});
            for (int i = size - 3; i >= 0; --i) {
                javaType = typeFactory.constructParametricType(types.get(i), new JavaType[]{javaType});
            }
            return (T)reader.forType(javaType).readValue(json);
        }
        catch (JsonProcessingException e) {
            LOGGER.atTrace().setCause((Throwable)e).setMessage("Failed to de-serialize: {}").addArgument(() -> ((JsonProcessingException)e).getMessage()).log();
            throw new RuntimeException(e);
        }
    }
}

