/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.spi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;

public final class JacksonConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonConfig.class);
    private static final List<String> MODULES = List.of("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "com.fasterxml.jackson.module.mrbean.MrBeanModule", "com.fasterxml.jackson.module.paramnames.ParameterNamesModule");

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        for (String name : MODULES) {
            if (!ClassUtils.isPresent((String)name, (ClassLoader)this.getClass().getClassLoader())) continue;
            try {
                objectMapper.registerModule((Module)Class.forName(name).getDeclaredConstructor(null).newInstance(null));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.atWarn().setCause((Throwable)e).setMessage("Failed to register module {}:{}").addArgument(name::toString).addArgument(e::getMessage).log();
            }
        }
        return objectMapper;
    }
}

