/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.api.spi;

import java.util.Map;
import java.util.Set;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.util.OneUtil;
import org.slf4j.MDC;

public final class MsgMDC {
    private MsgMDC() {
    }

    public static AutoCloseable set(JmsMsg msg) {
        if (msg == null) {
            return () -> {};
        }
        AutoCloseable closeable = () -> MsgMDC.clear(msg);
        MDC.put((String)MsgContextName.AufJmsMsgFrom.name(), (String)OneUtil.toString(msg.destination()));
        MDC.put((String)MsgContextName.AufJmsMsgType.name(), (String)msg.type());
        MDC.put((String)MsgContextName.AufJmsMsgCorrelationId.name(), (String)msg.correlationId());
        Set<String> propertyNames = msg.propertyNames();
        if (propertyNames == null) {
            return closeable;
        }
        propertyNames.stream().filter(name -> name.startsWith("AufJmsMsgMDC")).forEach(name -> MDC.put((String)name.replaceFirst("AufJmsMsgMDC", ""), (String)msg.property((String)name, String.class)));
        return closeable;
    }

    public static AutoCloseable set(JmsDispatch dispatch) {
        if (dispatch == null) {
            return () -> {};
        }
        AutoCloseable closeable = () -> MsgMDC.clear(dispatch);
        MDC.put((String)DispatchContextName.AufJmsDispatchTo.name(), (String)OneUtil.toString(dispatch.to()));
        MDC.put((String)DispatchContextName.AufJmsDispatchType.name(), (String)dispatch.type());
        MDC.put((String)DispatchContextName.AufJmsDispatchCorrelationId.name(), (String)dispatch.correlationId());
        Map<String, Object> properties = dispatch.properties();
        if (properties == null) {
            return closeable;
        }
        properties.keySet().stream().filter(name -> name.startsWith("AufJmsMsgMDC")).forEach(name -> MDC.put((String)name.replaceFirst("AufJmsMsgMDC", ""), (String)properties.get(name).toString()));
        return closeable;
    }

    public static void clear(JmsMsg msg) {
        if (msg == null) {
            return;
        }
        for (MsgContextName value : MsgContextName.values()) {
            MDC.remove((String)value.name());
        }
        Set<String> propertyNames = msg.propertyNames();
        if (propertyNames == null) {
            return;
        }
        propertyNames.stream().filter(name -> name.startsWith("AufJmsMsgMDC")).forEach(name -> MDC.remove((String)name.replaceFirst("AufJmsMsgMDC", "")));
    }

    public static void clear(JmsDispatch dispatch) {
        if (dispatch == null) {
            return;
        }
        for (DispatchContextName value : DispatchContextName.values()) {
            MDC.remove((String)value.name());
        }
        Map<String, Object> properties = dispatch.properties();
        if (properties == null) {
            return;
        }
        properties.keySet().stream().filter(name -> name.startsWith("AufJmsMsgMDC")).forEach(name -> MDC.remove((String)name.replaceFirst("AufJmsMsgMDC", "")));
    }

    private static enum MsgContextName {
        AufJmsMsgFrom,
        AufJmsMsgCorrelationId,
        AufJmsMsgType,
        AufJmsMsgMDC;

    }

    private static enum DispatchContextName {
        AufJmsDispatchTo,
        AufJmsDispatchCorrelationId,
        AufJmsDispatchType;

    }
}

