/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.configuration;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import jakarta.jms.ConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.api.spi.ExpressionResolver;
import me.ehp246.aufjms.core.dispatch.DefaultDispatchFnProvider;
import me.ehp246.aufjms.core.dispatch.DispatchLogger;
import me.ehp246.aufjms.core.inbound.NoOpConsumer;
import me.ehp246.aufjms.provider.jackson.JsonByObjectMapper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ClassUtils;

@Import(value={DefaultDispatchFnProvider.class})
public final class AufJmsConfiguration {
    private static final List<String> MODULES = List.of("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "com.fasterxml.jackson.module.mrbean.MrBeanModule", "com.fasterxml.jackson.module.paramnames.ParameterNamesModule");

    @Bean(value={"2392a7ae-3e11-4eeb-bd8c-cf54f5a1fa4b"})
    public DispatchLogger dispatchLogger(@Value(value="${me.ehp246.aufjms.dispatchlogger.enabled:false}") boolean enabled) {
        return enabled ? new DispatchLogger() : null;
    }

    @Bean(value={"2744a1e7-9576-4f2e-8c56-6623247155e7"})
    public ExpressionResolver expressionResolver(PropertyResolver springPropertyResolver, ConfigurableBeanFactory beanFactory) {
        StandardBeanExpressionResolver springSpelResolver = new StandardBeanExpressionResolver();
        BeanExpressionContext context = new BeanExpressionContext(beanFactory, null);
        return exp -> {
            if (exp.startsWith("#{")) {
                return springSpelResolver.evaluate(exp, context).toString();
            }
            return springPropertyResolver.resolveRequiredPlaceholders(exp);
        };
    }

    @Bean(value={"90462ee7-99cd-4ce9-b299-89c983a8b069"})
    public ConnectionFactoryProvider connectionFactoryProvider(BeanFactory beanFactory) {
        return name -> {
            if (name == null || name.isBlank()) {
                return (ConnectionFactory)beanFactory.getBean(ConnectionFactory.class);
            }
            return (ConnectionFactory)beanFactory.getBean(name, ConnectionFactory.class);
        };
    }

    @Bean(value={"44fc3968-7eba-47a3-a7b4-54e2b365d027"})
    public NoOpConsumer noOpConsumer() {
        return new NoOpConsumer();
    }

    @Bean(value={"ca50e6fd-0737-4cf2-ad54-77a2620c4735"})
    public JsonByObjectMapper jsonByObjectMapper(ApplicationContext appCtx) {
        ObjectMapper aufJmsObjectMapper = (ObjectMapper)appCtx.getBeansOfType(ObjectMapper.class).get("aufJmsObjectMapper");
        if (aufJmsObjectMapper != null) {
            return new JsonByObjectMapper(aufJmsObjectMapper);
        }
        try {
            return new JsonByObjectMapper((ObjectMapper)appCtx.getBean(ObjectMapper.class));
        }
        catch (Exception exception) {
            ObjectMapper newMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            for (String name : MODULES) {
                if (!ClassUtils.isPresent((String)name, (ClassLoader)this.getClass().getClassLoader())) continue;
                try {
                    newMapper.registerModule((Module)Class.forName(name).getDeclaredConstructor(null).newInstance(null));
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception2) {}
            }
            return new JsonByObjectMapper(newMapper);
        }
    }
}

