/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import me.ehp246.aufjms.api.dispatch.DispatchListener;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DispatchLogger
implements DispatchListener.OnDispatch,
DispatchListener.PreSend,
DispatchListener.PostSend,
DispatchListener.OnException {
    private static final Logger LOGGER = LoggerFactory.getLogger(DispatchLogger.class);

    @Override
    public void onDispatch(JmsDispatch dispatch) {
        if (dispatch == null) {
            return;
        }
        LOGGER.atInfo().addMarker(AufJmsConstants.HEADERS).setMessage("{}, {}, {}").addArgument(dispatch::correlationId).addArgument(dispatch::to).addArgument(dispatch::type).log();
    }

    @Override
    public void preSend(JmsDispatch dispatch, JmsMsg msg) {
        if (dispatch == null || msg == null) {
            return;
        }
        LOGGER.atTrace().addMarker(AufJmsConstants.PROPERTIES).setMessage("{}").addArgument(dispatch::properties).log();
        LOGGER.atTrace().addMarker(AufJmsConstants.BODY).setMessage("{}").addArgument(msg::text).log();
    }

    @Override
    public void postSend(JmsDispatch dispatch, JmsMsg msg) {
    }

    @Override
    public void onException(JmsDispatch dispatch, JmsMsg msg, Exception e) {
        if (e == null) {
            return;
        }
        LOGGER.atTrace().setCause((Throwable)e).addMarker(AufJmsConstants.EXCEPTION).setMessage("{}").addArgument(e::getMessage).log();
    }
}

