/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.dispatch;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.CompletableFuture;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import me.ehp246.aufjms.core.dispatch.ReplyFutureSupplier;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.listener.SessionAwareMessageListener;

final class ReplyListener
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplyListener.class);
    private final ReplyFutureSupplier futureSupplier;

    ReplyListener(ReplyFutureSupplier futureSupplier) {
        this.futureSupplier = futureSupplier;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Un-supported message type");
        }
        TextMessage textMessage = (TextMessage)message;
        JmsMsg msg = TextJmsMsg.from(textMessage);
        LOGGER.atDebug().addMarker(AufJmsConstants.HEADERS).setMessage("{}, {}").addArgument(msg::correlationId).addArgument(msg::type).log();
        LOGGER.atTrace().addMarker(AufJmsConstants.BODY).setMessage("{}").addArgument(msg::text).log();
        CompletableFuture<JmsMsg> future = this.futureSupplier.get(msg.correlationId());
        if (future == null) {
            LOGGER.atTrace().setMessage("{} not found, ignored").addArgument(msg::correlationId).log();
        } else {
            future.complete(msg);
        }
    }
}

