/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import me.ehp246.aufjms.api.exception.UnknownTypeException;
import me.ehp246.aufjms.api.inbound.InboundEndpoint;
import me.ehp246.aufjms.api.inbound.Invocable;
import me.ehp246.aufjms.api.inbound.InvocableDispatcher;
import me.ehp246.aufjms.api.inbound.InvocableFactory;
import me.ehp246.aufjms.api.inbound.MsgConsumer;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.MsgMDC;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import me.ehp246.aufjms.core.util.TextJmsMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.lang.Nullable;

public final class DefaultInboundMessageListener
implements SessionAwareMessageListener<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InboundEndpoint.class);
    private final InvocableDispatcher dispatcher;
    private final InvocableFactory invocableFactory;
    private final MsgConsumer defaultConsumer;

    public DefaultInboundMessageListener(InvocableDispatcher dispatcher, InvocableFactory invocableFactory, @Nullable MsgConsumer defaultConsumer) {
        this.dispatcher = dispatcher;
        this.invocableFactory = invocableFactory;
        this.defaultConsumer = defaultConsumer;
    }

    public void onMessage(Message message, Session session) throws JMSException {
        if (!(message instanceof TextMessage)) {
            throw new IllegalArgumentException("Un-supported message type");
        }
        TextMessage textMessage = (TextMessage)message;
        JmsMsg msg = TextJmsMsg.from(textMessage);
        try (AutoCloseable closeble = MsgMDC.set(msg);){
            LOGGER.atDebug().addMarker(AufJmsConstants.HEADERS).setMessage("{}, {}, {}").addArgument(msg::destination).addArgument(msg::type).addArgument(msg::correlationId).log();
            LOGGER.atTrace().addMarker(AufJmsConstants.BODY).setMessage("{}").addArgument(msg::text).log();
            Invocable invocable = this.invocableFactory.get(msg);
            if (invocable == null) {
                if (this.defaultConsumer == null) {
                    throw new UnknownTypeException(msg);
                }
                this.defaultConsumer.accept(msg);
                return;
            }
            this.dispatcher.dispatch(invocable, msg);
        }
        catch (JMSException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

