/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import com.fasterxml.jackson.annotation.JsonView;
import jakarta.jms.TextMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.ehp246.aufjms.api.annotation.OfCorrelationId;
import me.ehp246.aufjms.api.annotation.OfDeliveryCount;
import me.ehp246.aufjms.api.annotation.OfGroupId;
import me.ehp246.aufjms.api.annotation.OfGroupSeq;
import me.ehp246.aufjms.api.annotation.OfMDC;
import me.ehp246.aufjms.api.annotation.OfProperty;
import me.ehp246.aufjms.api.annotation.OfRedelivered;
import me.ehp246.aufjms.api.annotation.OfType;
import me.ehp246.aufjms.api.inbound.BoundInvocable;
import me.ehp246.aufjms.api.inbound.Invocable;
import me.ehp246.aufjms.api.inbound.InvocableBinder;
import me.ehp246.aufjms.api.jms.BodyOf;
import me.ehp246.aufjms.api.jms.FromJson;
import me.ehp246.aufjms.api.jms.JMSSupplier;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.BodyOfBuilder;
import me.ehp246.aufjms.core.reflection.ReflectedMethod;
import me.ehp246.aufjms.core.reflection.ReflectedParameter;
import me.ehp246.aufjms.core.reflection.ReflectedType;
import me.ehp246.aufjms.core.util.OneUtil;

public final class DefaultInvocableBinder
implements InvocableBinder {
    private static final Map<Class<? extends Annotation>, Function<JmsMsg, Object>> HEADER_VALUE_SUPPLIERS = Map.of(OfType.class, JmsMsg::type, OfCorrelationId.class, JmsMsg::correlationId, OfDeliveryCount.class, msg -> msg.property("JMSXDeliveryCount", Integer.class), OfGroupId.class, JmsMsg::groupId, OfGroupSeq.class, JmsMsg::groupSeq, OfRedelivered.class, JmsMsg::redelivered);
    private static final Set<Class<? extends Annotation>> HEADER_ANNOTATIONS = Set.copyOf(HEADER_VALUE_SUPPLIERS.keySet());
    private final FromJson fromJson;
    private final Map<Method, ArgBinders> parsed = new ConcurrentHashMap<Method, ArgBinders>();

    public DefaultInvocableBinder(FromJson fromJson) {
        this.fromJson = fromJson;
    }

    @Override
    public BoundInvocable bind(final Invocable target, final JmsMsg msg) {
        Method method = target.method();
        ArgBinders argBinders = this.parsed.computeIfAbsent(method, this::parse);
        Map<Integer, Function<JmsMsg, Object>> paramBinders = argBinders.paramBinders();
        int parameterCount = method.getParameterCount();
        final Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            arguments[i] = paramBinders.get(i).apply(msg);
        }
        Map<String, Function<Object[], String>> msgMDCBinders = argBinders.msgMDCBinders();
        final HashMap mdc = new HashMap();
        if (msgMDCBinders != null && msgMDCBinders.size() > 0) {
            msgMDCBinders.entrySet().stream().forEach(entry -> mdc.put((String)entry.getKey(), (String)((Function)msgMDCBinders.get(entry.getKey())).apply(arguments)));
        }
        return new BoundInvocable(){

            @Override
            public Invocable invocable() {
                return target;
            }

            @Override
            public JmsMsg msg() {
                return msg;
            }

            @Override
            public Object[] arguments() {
                return arguments;
            }

            @Override
            public Map<String, String> mdc() {
                return mdc;
            }
        };
    }

    private ArgBinders parse(Method method) {
        Parameter[] parameters = method.getParameters();
        HashMap<Integer, Function<JmsMsg, Object>> paramBinders = new HashMap<Integer, Function<JmsMsg, Object>>();
        ReflectedParameter[] bodyParamef = new ReflectedParameter[]{null};
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            Class<Object> type = parameter.getType();
            if (type.isAssignableFrom(JmsMsg.class)) {
                paramBinders.put(i, msg -> msg);
                continue;
            }
            if (type.isAssignableFrom(TextMessage.class)) {
                paramBinders.put(i, JmsMsg::message);
                continue;
            }
            if (type.isAssignableFrom(FromJson.class)) {
                paramBinders.put(i, msg -> this.fromJson);
                continue;
            }
            Annotation[] annotations = parameter.getAnnotations();
            Optional<Annotation> header = Stream.of(annotations).filter(annotation -> HEADER_ANNOTATIONS.contains(annotation.annotationType())).findAny();
            if (header.isPresent()) {
                Function<JmsMsg, Object> fn = HEADER_VALUE_SUPPLIERS.get(header.get().annotationType());
                paramBinders.put(i, msg -> fn.apply((JmsMsg)msg));
                continue;
            }
            Optional<OfProperty> prop = Stream.of(annotations).filter(ann -> ann.annotationType() == OfProperty.class).findAny().map(ann -> (OfProperty)ann);
            if (prop.isPresent()) {
                if (Map.class.isAssignableFrom(type)) {
                    paramBinders.put(i, msg -> msg.propertyNames().stream().collect(Collectors.toMap(Function.identity(), name -> JMSSupplier.invoke(() -> msg.message().getObjectProperty(name)))));
                    continue;
                }
                String name = OneUtil.getIfBlank(prop.get().value(), () -> OneUtil.firstUpper(parameter.getName()));
                paramBinders.put(i, msg -> msg.property(name, type));
                continue;
            }
            BodyOf<?> bodyOf = BodyOfBuilder.ofView(Optional.ofNullable(parameter.getAnnotation(JsonView.class)).map(JsonView::value).map(OneUtil::firstOrNull).orElse(null), parameter.getType());
            paramBinders.put(i, msg -> msg.text() == null ? null : this.fromJson.apply(msg.text(), bodyOf));
            bodyParamef[0] = new ReflectedParameter(parameters[i], i);
        }
        HashMap<String, Function<Object[], String>> msgMDCBinders = new HashMap<String, Function<Object[], String>>();
        msgMDCBinders.putAll(new ReflectedMethod(method).allParametersWith(OfMDC.class).stream().filter(p -> p.parameter().getAnnotation(OfMDC.class).op() == OfMDC.Op.Default).collect(Collectors.toMap(p -> {
            String name = p.parameter().getAnnotation(OfMDC.class).value();
            return OneUtil.hasValue(name) ? name : p.parameter().getName();
        }, p -> {
            int index = p.index();
            return args -> args[index] == null ? null : String.valueOf(args[index]);
        }, (l, r) -> r)));
        ReflectedParameter bodyReflectedParam = bodyParamef[0];
        if (bodyReflectedParam == null || bodyReflectedParam.parameter().getAnnotation(OfMDC.class) == null) {
            return new ArgBinders(paramBinders, msgMDCBinders);
        }
        Parameter bodyParam = bodyReflectedParam.parameter();
        int bodyParamIndex = bodyReflectedParam.index();
        OfMDC ofMDC = bodyParam.getAnnotation(OfMDC.class);
        switch (ofMDC.op()) {
            case Introspect: {
                String bodyParamContextName = ofMDC.value();
                Map<String, Function> bodyFieldBinders = new ReflectedType(bodyParam.getType()).streamSuppliersWith(OfMDC.class).filter(m -> m.getAnnotation(OfMDC.class).op() == OfMDC.Op.Default).collect(Collectors.toMap(m -> bodyParamContextName + Optional.of(m.getAnnotation(OfMDC.class).value()).filter(OneUtil::hasValue).orElseGet(m::getName), Function.identity(), (l, r) -> r)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    Method m = (Method)entry.getValue();
                    return args -> {
                        Object body = args[bodyParamIndex];
                        if (body == null) {
                            return null;
                        }
                        try {
                            Object ret = m.invoke(body, new Object[0]);
                            return ret == null ? null : String.valueOf(ret);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    };
                }));
                msgMDCBinders.putAll(bodyFieldBinders);
                break;
            }
            default: {
                msgMDCBinders.put(Optional.ofNullable(bodyParam.getAnnotation(OfMDC.class)).map(OfMDC::value).filter(OneUtil::hasValue).orElseGet(bodyParam::getName), args -> args[bodyParamIndex] == null ? null : String.valueOf(args[bodyParamIndex]));
            }
        }
        return new ArgBinders(paramBinders, msgMDCBinders);
    }

    record ArgBinders(Map<Integer, Function<JmsMsg, Object>> paramBinders, Map<String, Function<Object[], String>> msgMDCBinders) {
    }
}

