/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import me.ehp246.aufjms.api.exception.BoundInvocationFailedException;
import me.ehp246.aufjms.api.inbound.BoundInvocable;
import me.ehp246.aufjms.api.inbound.Invocable;
import me.ehp246.aufjms.api.inbound.InvocableBinder;
import me.ehp246.aufjms.api.inbound.InvocableDispatcher;
import me.ehp246.aufjms.api.inbound.InvocationListener;
import me.ehp246.aufjms.api.inbound.InvocationModel;
import me.ehp246.aufjms.api.inbound.Invoked;
import me.ehp246.aufjms.api.jms.JmsMsg;
import me.ehp246.aufjms.api.spi.MsgMDC;
import me.ehp246.aufjms.core.configuration.AufJmsConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.lang.Nullable;

final class DefaultInvocableDispatcher
implements InvocableDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvocableDispatcher.class);
    private final Executor executor;
    private final InvocableBinder binder;
    private final List<InvocationListener.OnInvoking> invoking = new ArrayList<InvocationListener.OnInvoking>();
    private final List<InvocationListener.OnCompleted> completed = new ArrayList<InvocationListener.OnCompleted>();
    private final List<InvocationListener.OnFailed> failed = new ArrayList<InvocationListener.OnFailed>();

    public DefaultInvocableDispatcher(InvocableBinder binder, @Nullable List<InvocationListener> listeners, @Nullable Executor executor) {
        this.binder = binder;
        this.executor = executor;
        for (Object listener : listeners == null ? List.of() : listeners) {
            if (listener instanceof InvocationListener.OnInvoking) {
                InvocationListener.OnInvoking invoking = (InvocationListener.OnInvoking)listener;
                this.invoking.add(invoking);
            }
            if (listener instanceof InvocationListener.OnCompleted) {
                InvocationListener.OnCompleted completed = (InvocationListener.OnCompleted)listener;
                this.completed.add(completed);
            }
            if (!(listener instanceof InvocationListener.OnFailed)) continue;
            InvocationListener.OnFailed failed = (InvocationListener.OnFailed)listener;
            this.failed.add(failed);
        }
    }

    @Override
    public void dispatch(Invocable invocable, JmsMsg msg) {
        BoundInvocable[] boundRef = new BoundInvocable[]{null};
        Runnable runnable = () -> {
            Object bound;
            try {
                boundRef[0] = this.binder.bind(invocable, msg);
                bound = boundRef[0];
                Optional.ofNullable(bound.mdc()).orElseGet(Map::of).entrySet().stream().forEach(e -> MDC.put((String)((String)e.getKey()), (String)((String)e.getValue())));
                this.invoking.forEach(arg_0 -> DefaultInvocableDispatcher.lambda$dispatch$1((BoundInvocable)bound, arg_0));
                Invoked outcome = bound.invoke();
                if (outcome instanceof Invoked.Failed) {
                    Invoked.Failed failed = (Invoked.Failed)outcome;
                    for (InvocationListener.OnFailed listener2 : this.failed) {
                        try {
                            listener2.onFailed(failed);
                        }
                        catch (Exception e2) {
                            failed.thrown().addSuppressed(e2);
                        }
                    }
                    Throwable patt0$temp = failed.thrown();
                    if (patt0$temp instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)patt0$temp;
                        throw re;
                    }
                    throw new BoundInvocationFailedException(failed.thrown());
                }
                Invoked.Completed completed = (Invoked.Completed)outcome;
                this.completed.forEach(listener -> listener.onCompleted(completed));
            }
            finally {
                try {
                    bound = invocable;
                    if (bound != null) {
                        bound.close();
                    }
                }
                catch (Exception e3) {
                    LOGGER.atWarn().setCause((Throwable)e3).addMarker(AufJmsConstants.EXCEPTION).setMessage("Ignored: {}").addArgument(e3::getMessage).log();
                }
                Optional.ofNullable(boundRef[0]).map(BoundInvocable::mdc).orElseGet(Map::of).entrySet().stream().forEach(e -> MDC.remove((String)((String)e.getKey())));
            }
        };
        if (this.executor == null || invocable.invocationModel() == InvocationModel.INLINE) {
            runnable.run();
        } else {
            this.executor.execute(() -> {
                try (AutoCloseable closeable = MsgMDC.set(msg);){
                    runnable.run();
                }
                catch (Exception e) {
                    LOGGER.atWarn().setCause((Throwable)e).addMarker(AufJmsConstants.EXCEPTION).setMessage("Ignored: {}").addArgument(e::getMessage).log();
                }
            });
        }
    }

    private static /* synthetic */ void lambda$dispatch$1(BoundInvocable bound, InvocationListener.OnInvoking listener) {
        listener.onInvoking(bound);
    }
}

