/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFnProvider;
import me.ehp246.aufjms.api.inbound.ExecutorProvider;
import me.ehp246.aufjms.api.inbound.InboundEndpoint;
import me.ehp246.aufjms.api.inbound.InvocableBinder;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.AtTopic;
import me.ehp246.aufjms.api.jms.ConnectionFactoryProvider;
import me.ehp246.aufjms.core.inbound.AutowireCapableInvocableFactory;
import me.ehp246.aufjms.core.inbound.DefaultInboundMessageListener;
import me.ehp246.aufjms.core.inbound.DefaultInvocableDispatcher;
import me.ehp246.aufjms.core.inbound.ReplyInvoked;
import me.ehp246.aufjms.core.util.OneUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.MessageListenerContainer;

public final class InboundEndpointListenerConfigurer
implements JmsListenerConfigurer {
    static final Logger LOGGER = LoggerFactory.getLogger(InboundEndpointListenerConfigurer.class);
    private final Set<InboundEndpoint> endpoints;
    private final ExecutorProvider executorProvider;
    private final InvocableBinder binder;
    private final ConnectionFactoryProvider cfProvider;
    private final JmsDispatchFnProvider dispathFnProvider;
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;

    public InboundEndpointListenerConfigurer(ConnectionFactoryProvider cfProvider, Set<InboundEndpoint> endpoints, ExecutorProvider executorProvider, InvocableBinder binder, JmsDispatchFnProvider dispathFnProvider, AutowireCapableBeanFactory autowireCapableBeanFactory) {
        this.cfProvider = Objects.requireNonNull(cfProvider);
        this.endpoints = endpoints;
        this.executorProvider = executorProvider;
        this.binder = binder;
        this.dispathFnProvider = dispathFnProvider;
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
    }

    public void configureJmsListeners(JmsListenerEndpointRegistrar registrar) {
        for (final InboundEndpoint endpoint : this.endpoints) {
            LOGGER.atTrace().setMessage("Registering '{}' on '{}', '{}'").addArgument(endpoint::name).addArgument(() -> endpoint.from().on()).addArgument(() -> endpoint.from().sub()).log();
            DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
            factory.setConnectionFactory(this.cfProvider.get(endpoint.connectionFactory()));
            factory.setSessionTransacted(Boolean.valueOf(endpoint.sessionMode() == 0));
            factory.setSessionAcknowledgeMode(Integer.valueOf(endpoint.sessionMode()));
            factory.setExceptionListener(endpoint.exceptionListener());
            factory.setErrorHandler(endpoint.errorHandler());
            registrar.registerEndpoint(new JmsListenerEndpoint(){

                public void setupListenerContainer(MessageListenerContainer listenerContainer) {
                    AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listenerContainer;
                    InboundEndpoint.From from = endpoint.from();
                    At on = from.on();
                    container.setBeanName(OneUtil.firstUpper(endpoint.name()) + "@" + String.valueOf(on));
                    container.setAutoStartup(endpoint.autoStartup());
                    container.setMessageSelector(from.selector());
                    container.setDestinationName(on.name());
                    container.setPubSubDomain(on instanceof AtTopic);
                    if (on instanceof AtTopic) {
                        InboundEndpoint.From.Sub sub = from.sub();
                        container.setSubscriptionName(sub.name());
                        container.setSubscriptionDurable(sub.durable());
                        container.setSubscriptionShared(sub.shared());
                    }
                    container.setupMessageListener((Object)new DefaultInboundMessageListener(new DefaultInvocableDispatcher(InboundEndpointListenerConfigurer.this.binder, Arrays.asList(new ReplyInvoked(InboundEndpointListenerConfigurer.this.dispathFnProvider.get(endpoint.connectionFactory())), endpoint.invocationListener()), InboundEndpointListenerConfigurer.this.executorProvider.get(endpoint.concurrency())), new AutowireCapableInvocableFactory(InboundEndpointListenerConfigurer.this.autowireCapableBeanFactory, endpoint.typeRegistry()), endpoint.defaultConsumer()));
                }

                public String getId() {
                    return endpoint.name();
                }
            }, (JmsListenerContainerFactory)factory);
        }
    }
}

