/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.inbound;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import me.ehp246.aufjms.api.dispatch.JmsDispatchFn;
import me.ehp246.aufjms.api.inbound.InvocationListener;
import me.ehp246.aufjms.api.inbound.Invoked;
import me.ehp246.aufjms.api.jms.At;
import me.ehp246.aufjms.api.jms.JmsDispatch;
import me.ehp246.aufjms.api.jms.JmsMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReplyInvoked
implements InvocationListener.OnCompleted {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplyInvoked.class);
    private final JmsDispatchFn dispatchFn;

    ReplyInvoked(JmsDispatchFn dispatchFn) {
        this.dispatchFn = dispatchFn;
    }

    @Override
    public void onCompleted(Invoked.Completed completed) {
        JmsMsg msg = completed.bound().msg();
        Destination replyTo = msg.replyTo();
        if (replyTo == null) {
            return;
        }
        LOGGER.atTrace().log("Replying to {}", (Object)replyTo);
        this.dispatchFn.send(JmsDispatch.toDispatch(ReplyInvoked.toAt(replyTo), msg.type(), completed.returned(), msg.correlationId()));
    }

    private static At toAt(Destination replyTo) {
        try {
            return replyTo instanceof Queue ? At.toQueue(((Queue)replyTo).getQueueName()) : At.toTopic(((Topic)replyTo).getTopicName());
        }
        catch (JMSException e) {
            throw new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
    }
}

