/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import me.ehp246.aufjms.core.reflection.ReflectedParameter;

public final class ReflectedMethod {
    private final Class<?> declaringType;
    private final Method method;
    private final Parameter[] parameters;
    private final List<Class<?>> exceptionTypes;

    public ReflectedMethod(Method method) {
        this.method = Objects.requireNonNull(method);
        this.declaringType = method.getDeclaringClass();
        this.parameters = method.getParameters();
        this.exceptionTypes = List.of(method.getExceptionTypes());
    }

    public Optional<ReflectedParameter> firstPayloadParameter(Set<Class<? extends Annotation>> exclusions) {
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = this.parameters[i];
            if (!exclusions.stream().filter(type -> parameter.isAnnotationPresent((Class<? extends Annotation>)type)).findAny().isEmpty()) continue;
            return Optional.of(new ReflectedParameter(parameter, i));
        }
        return Optional.empty();
    }

    public List<ReflectedParameter> allParametersWith(Class<? extends Annotation> annotationType) {
        ArrayList<ReflectedParameter> list = new ArrayList<ReflectedParameter>();
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter parameter = this.parameters[i];
            if (!parameter.isAnnotationPresent(annotationType)) continue;
            list.add(new ReflectedParameter(parameter, i));
        }
        return list;
    }

    public Method method() {
        return this.method;
    }

    public Parameter getParameter(int index) {
        return this.parameters[index];
    }

    public <A extends Annotation> Optional<A> findOnMethodUp(Class<A> annotationClass) {
        A found = this.method.getAnnotation(annotationClass);
        if (found != null) {
            return Optional.of(found);
        }
        return Optional.ofNullable(this.declaringType.getAnnotation(annotationClass));
    }

    public boolean isOnThrows(Class<?> type) {
        return RuntimeException.class.isAssignableFrom(type) || this.exceptionTypes.stream().filter(t -> t.isAssignableFrom(type)).findAny().isPresent();
    }

    public boolean returnsVoid() {
        Class<?> returnType = this.method.getReturnType();
        return returnType == Void.TYPE || returnType == Void.class;
    }
}

