/*
 * Decompiled with CFR 0.152.
 */
package me.ehp246.aufjms.core.util;

import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OneUtil {
    private OneUtil() {
    }

    public static String firstUpper(String value) {
        return value == null || value.length() == 0 ? value : value.substring(0, 1).toUpperCase(Locale.US) + value.substring(1);
    }

    public static String toString(Object value) {
        return OneUtil.toString(value, null);
    }

    public static String toString(Object value, String def) {
        return value == null ? def : value.toString();
    }

    public static String nullIfBlank(Object value) {
        return OneUtil.nullIfBlank(OneUtil.toString(value));
    }

    public static String nullIfBlank(String value) {
        return value != null && !value.isBlank() ? value : null;
    }

    public static boolean hasValue(String value) {
        return value != null && !value.isBlank();
    }

    public static boolean hasValue(Object[] value) {
        return value != null && value.length > 0;
    }

    public static <T> T firstOrNull(T[] value) {
        return value != null && value.length > 0 ? (T)value[0] : null;
    }

    public static String getIfBlank(String value, Supplier<String> supplier) {
        if (value == null || value.isBlank()) {
            return supplier.get();
        }
        return value;
    }

    public static Stream<String> streamValues(Collection<String> values) {
        return Optional.ofNullable(values).orElseGet(ArrayList::new).stream().filter(OneUtil::hasValue);
    }

    public static List<String> listValues(Collection<String> values) {
        return OneUtil.streamValues(values).collect(Collectors.toList());
    }

    public static <V> V orElse(Callable<V> callable, V v) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return v;
        }
    }

    public static <V> V orThrow(Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V orThrow(Callable<V> callable, String msg) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(msg, e);
        }
    }

    public static <V, X extends RuntimeException> V orThrow(Callable<V> callable, Function<Exception, X> fn) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw (RuntimeException)fn.apply(e);
        }
    }

    public static boolean isPresent(List<? extends Annotation> annos, Class<? extends Annotation> type) {
        return OneUtil.filter(annos, type).findAny().isPresent();
    }

    public static Stream<? extends Annotation> filter(List<? extends Annotation> annos, Class<? extends Annotation> type) {
        return Optional.ofNullable(annos).filter(Objects::nonNull).orElseGet(ArrayList::new).stream().filter(anno -> anno.annotationType() == type);
    }

    public static RuntimeException ensureRuntime(Throwable thrown) {
        if (thrown == null) {
            return null;
        }
        if (thrown instanceof RuntimeException) {
            RuntimeException runtime = (RuntimeException)thrown;
            return runtime;
        }
        if (thrown instanceof JMSException) {
            JMSException jmsE = (JMSException)thrown;
            return new JMSRuntimeException(jmsE.getMessage(), jmsE.getErrorCode(), (Throwable)jmsE);
        }
        return new RuntimeException(thrown);
    }
}

