/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven.impl.step.fetch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.friwi.jcefmaven.CefBuildInfo;
import me.friwi.jcefmaven.EnumPlatform;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class PackageDownloader {
    private static final Logger LOGGER = Logger.getLogger(PackageDownloader.class.getName());
    private static final int BUFFER_SIZE = 16384;

    public static void downloadNatives(CefBuildInfo info, EnumPlatform platform, File destination, Consumer<Float> progressConsumer, Set<String> mirrors) throws IOException {
        Objects.requireNonNull(info, "info cannot be null");
        Objects.requireNonNull(platform, "platform cannot be null");
        Objects.requireNonNull(destination, "destination cannot be null");
        Objects.requireNonNull(progressConsumer, "progressConsumer cannot be null");
        Objects.requireNonNull(mirrors, "mirrors can not be null");
        if (mirrors.isEmpty()) {
            throw new RuntimeException("mirrors can not be empty");
        }
        if (!destination.createNewFile()) {
            throw new IOException("Could not create target file " + destination.getAbsolutePath());
        }
        String mvn_version = PackageDownloader.loadJCefMavenVersion();
        Exception lastException = null;
        for (String mirror : mirrors) {
            String m = mirror.replace("{platform}", platform.getIdentifier()).replace("{tag}", info.getReleaseTag()).replace("{mvn_version}", mvn_version);
            try {
                URL url = new URL(m);
                HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                try {
                    InputStream in = uc.getInputStream();
                    try {
                        if (uc.getResponseCode() != 200) {
                            LOGGER.log(Level.WARNING, "Request to mirror failed with code " + uc.getResponseCode() + " from server: " + m);
                            continue;
                        }
                        long length = uc.getContentLengthLong();
                        try (FileOutputStream fos = new FileOutputStream(destination);){
                            int r;
                            long progress = 0L;
                            progressConsumer.accept(Float.valueOf(0.0f));
                            byte[] buffer = new byte[16384];
                            long transferred = 0L;
                            while ((r = in.read(buffer)) > 0) {
                                fos.write(buffer, 0, r);
                                long newprogress = (transferred += (long)r) * 100L / length;
                                if (newprogress <= progress) continue;
                                progress = newprogress;
                                progressConsumer.accept(Float.valueOf(progress));
                            }
                            fos.flush();
                        }
                        uc.disconnect();
                        return;
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    lastException = e;
                    LOGGER.log(Level.WARNING, "Request failed with exception on mirror: " + m + " (" + e.getClass().getSimpleName() + (e.getMessage() == null ? "" : ": " + e.getMessage()) + ")");
                    uc.disconnect();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Request failed with exception on mirror: " + m, e);
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new IOException("None of the supplied mirrors were working", lastException);
        }
        throw new IOException("None of the supplied mirrors were working");
    }

    private static String loadJCefMavenVersion() throws IOException {
        Object object;
        JSONParser parser = new JSONParser();
        try {
            object = parser.parse((Reader)new InputStreamReader(PackageDownloader.class.getResourceAsStream("/jcefmaven_build_meta.json")));
        }
        catch (Exception e) {
            throw new IOException("Invalid json content in jcefmaven_build_meta.json", e);
        }
        if (!(object instanceof JSONObject)) {
            throw new IOException("jcefmaven_build_meta.json did not contain a valid json body");
        }
        return (String)((JSONObject)object).get((Object)"version");
    }
}

