/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven.impl.step.extract;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarGzExtractor {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger LOGGER = Logger.getLogger(TarGzExtractor.class.getName());

    public static void extractTarGZ(File installDir, InputStream in) throws IOException {
        Objects.requireNonNull(installDir, "installDir cannot be null");
        Objects.requireNonNull(in, "in cannot be null");
        GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(in);
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                File f = new File(installDir, entry.getName());
                if (entry.isDirectory()) {
                    boolean created = f.mkdir();
                    if (!created) {
                        LOGGER.log(Level.SEVERE, "Unable to create directory '%s', during extraction of archive contents.\n", f.getAbsolutePath());
                        continue;
                    }
                    if ((entry.getMode() & 0x49) == 0 || f.setExecutable(true, false)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to mark directory '%s' executable, during extraction of archive contents.\n", f.getAbsolutePath());
                    continue;
                }
                byte[] data = new byte[4096];
                FileOutputStream fos = new FileOutputStream(f, false);
                try (BufferedOutputStream dest = new BufferedOutputStream(fos, 4096);){
                    int count;
                    while ((count = tarIn.read(data, 0, 4096)) != -1) {
                        dest.write(data, 0, count);
                    }
                }
                if ((entry.getMode() & 0x49) == 0 || f.setExecutable(true, false)) continue;
                LOGGER.log(Level.SEVERE, "Unable to mark file '%s' executable, during extraction of archive contents.\n", f.getAbsolutePath());
            }
        }
    }
}

