/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import org.cef.CefApp;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CefBuildInfo {
    private static CefBuildInfo LOCAL_BUILD_INFO = null;
    private final String jcefUrl;
    private final String releaseTag;
    private final String releaseUrl;
    private final String platform;

    private CefBuildInfo(String jcefUrl, String releaseTag, String releaseUrl, String platform) {
        this.jcefUrl = jcefUrl;
        this.releaseTag = releaseTag;
        this.releaseUrl = releaseUrl;
        this.platform = platform;
    }

    public static CefBuildInfo fromClasspath() throws IOException {
        if (LOCAL_BUILD_INFO == null) {
            LOCAL_BUILD_INFO = CefBuildInfo.loadData(Objects.requireNonNull(CefApp.class.getResourceAsStream("/build_meta.json"), "The build_meta.json file from the jcef-api artifact could not be read"));
        }
        return LOCAL_BUILD_INFO;
    }

    public static CefBuildInfo fromFile(File file) throws IOException {
        return CefBuildInfo.loadData(new FileInputStream(file));
    }

    private static CefBuildInfo loadData(InputStream in) throws IOException {
        JSONParser parser = new JSONParser();
        Object object = null;
        try {
            object = parser.parse((Reader)new InputStreamReader(in));
        }
        catch (ParseException e) {
            throw new IOException("Invalid json content in build_meta.json", e);
        }
        if (!(object instanceof JSONObject)) {
            throw new IOException("build_meta.json did not contain a valid json body");
        }
        JSONObject jsonObject = (JSONObject)object;
        return new CefBuildInfo(Objects.requireNonNull(jsonObject.get((Object)"jcef_url"), "No jcef_url specified in build_meta.json").toString(), Objects.requireNonNull(jsonObject.get((Object)"release_tag"), "No release_tag specified in build_meta.json").toString(), Objects.requireNonNull(jsonObject.get((Object)"release_url"), "No release_url specified in build_meta.json").toString(), Objects.requireNonNull(jsonObject.get((Object)"platform"), "No platform specified in build_meta.json").toString());
    }

    public String getJcefUrl() {
        return this.jcefUrl;
    }

    public String getReleaseTag() {
        return this.releaseTag;
    }

    public String getReleaseUrl() {
        return this.releaseUrl;
    }

    public String getPlatform() {
        return this.platform;
    }
}

