/*
 * Decompiled with CFR 0.152.
 */
package me.friwi.jcefmaven.impl.step.fetch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.friwi.jcefmaven.CefBuildInfo;
import me.friwi.jcefmaven.EnumPlatform;

public class PackageDownloader {
    private static final Logger LOGGER = Logger.getLogger(PackageDownloader.class.getName());
    private static final String USER = "jcefmavenbot";
    private static final String TOKEN = new String(Base64.getDecoder().decode("Z2hwX0JWblZMMmlpWG9sR2VneHBRYWZZeUVCUnlTOWl3djJ1UHJGag=="), StandardCharsets.UTF_8);
    private static final String DOWNLOAD_URL = "https://maven.pkg.github.com/jcefmaven/jcefmaven/me/friwi/jcef-natives-{platform}/{tag}/jcef-natives-{platform}-{tag}.jar";
    private static final String FALLBACK_DOWNLOAD_URL = "https://repo.maven.apache.org/maven2/me/friwi/jcef-natives-{platform}/{tag}/jcef-natives-{platform}-{tag}.jar";
    private static final int BUFFER_SIZE = 16384;

    public static void downloadNatives(CefBuildInfo info, EnumPlatform platform, File destination, Consumer<Float> progressConsumer) throws IOException {
        int r;
        Objects.requireNonNull(info, "info cannot be null");
        Objects.requireNonNull(platform, "platform cannot be null");
        Objects.requireNonNull(destination, "destination cannot be null");
        Objects.requireNonNull(progressConsumer, "progressConsumer cannot be null");
        if (!destination.createNewFile()) {
            throw new IOException("Could not create target file " + destination.getAbsolutePath());
        }
        URL url = new URL(DOWNLOAD_URL.replace("{platform}", platform.getIdentifier()).replace("{tag}", info.getReleaseTag()));
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        String userpass = "jcefmavenbot:" + TOKEN;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()), StandardCharsets.UTF_8);
        uc.setRequestProperty("Authorization", basicAuth);
        InputStream in = null;
        try {
            in = uc.getInputStream();
        }
        catch (IOException e) {
            uc.disconnect();
        }
        if (uc.getResponseCode() != 200) {
            LOGGER.log(Level.WARNING, "Requesting from sonatype due to " + uc.getResponseCode() + " from github");
            url = new URL(FALLBACK_DOWNLOAD_URL.replace("{platform}", platform.getIdentifier()).replace("{tag}", info.getReleaseTag()));
            uc = (HttpURLConnection)url.openConnection();
            in = uc.getInputStream();
        }
        long length = uc.getContentLengthLong();
        FileOutputStream fos = new FileOutputStream(destination);
        long progress = 0L;
        progressConsumer.accept(Float.valueOf(0.0f));
        byte[] buffer = new byte[16384];
        long transferred = 0L;
        while ((r = in.read(buffer)) > 0) {
            fos.write(buffer, 0, r);
            long newprogress = (transferred += (long)r) * 100L / length;
            if (newprogress <= progress) continue;
            progress = newprogress;
            progressConsumer.accept(Float.valueOf(progress));
        }
        fos.flush();
        fos.close();
        in.close();
        uc.disconnect();
    }
}

