/*
 * Decompiled with CFR 0.152.
 */
package me.frmr.kafka.detective.matchfinder;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.DatatypeConverter;
import me.frmr.kafka.detective.api.FoundMatch;
import me.frmr.kafka.detective.api.MonitorMatchFindResult;
import me.frmr.kafka.detective.api.MonitorMatchFinder;
import me.frmr.kafka.detective.api.MonitorObjectEnvelope;
import me.frmr.kafka.detective.api.NoMatchFound;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.concurrent.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001B\u0001\u0003\u00015\u0011qbS3z\u000bF,\u0018\r\\:GS:$WM\u001d\u0006\u0003\u0007\u0011\t1\"\\1uG\"4\u0017N\u001c3fe*\u0011QAB\u0001\nI\u0016$Xm\u0019;jm\u0016T!a\u0002\u0005\u0002\u000b-\fgm[1\u000b\u0005%Q\u0011\u0001\u00024s[JT\u0011aC\u0001\u0003[\u0016\u001c\u0001a\u0005\u0003\u0001\u001dQQ\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005\u0019\u0011\r]5\n\u0005e1\"AE'p]&$xN]'bi\u000eDg)\u001b8eKJ\u0004\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\n1aY8n\u0013\t\u0019CDA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003\tAaA\u000b\u0001!\u0002\u0013Y\u0013\u0001C:fK:\\U-_:\u0011\t1\n4GP\u0007\u0002[)\u0011afL\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u0019\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003e5\u00121!T1q!\t!4H\u0004\u00026sA\u0011a\u0007E\u0007\u0002o)\u0011\u0001\bD\u0001\u0007yI|w\u000e\u001e \n\u0005i\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!A\u000f\t\u0011\u0005=y\u0014B\u0001!\u0011\u0005\u0011auN\\4\t\r\t\u0003\u0001\u0015!\u0003D\u00031\u0019X-\u001a8LKf\u001cHj\\2l!\t!E*D\u0001F\u0015\t1u)A\u0003m_\u000e\\7O\u0003\u0002/\u0011*\u0011\u0011JS\u0001\u0005kRLGNC\u0001L\u0003\u0011Q\u0017M^1\n\u00055+%A\u0006*fK:$(/\u00198u%\u0016\fGm\u0016:ji\u0016dunY6\t\r=\u0003\u0001\u0015)\u0003Q\u0003Qa\u0017m\u001d;TK\u0016t7*Z=t\u00072,\u0017M\\5oOB\u0011\u0011\u000bV\u0007\u0002%*\u00111KS\u0001\u0005i&lW-\u0003\u0002V%\n9\u0011J\\:uC:$\bBB,\u0001A\u0013%\u0001,\u0001\btK\u0016t7*Z=t\u0017\u0016Lhi\u001c:\u0015\u0005MJ\u0006\"\u0002.W\u0001\u0004Y\u0016!B5oaV$\bC\u0001/`\u001b\u0005i&B\u00010K\u0003\u0011a\u0017M\\4\n\u0005\u0001l&AB(cU\u0016\u001cG\u000f\u0003\u0004c\u0001\u0001&IaY\u0001\u0016g\u0016,gnS3zg:+W\rZ:DY\u0016\fg.\u001b8h)\u0005!\u0007CA\bf\u0013\t1\u0007CA\u0004C_>dW-\u00198\t\r!\u0004\u0001\u0015\"\u0003j\u00035\u0001(/\u001e8f'\u0016,gnS3zgR\u0011!.\u001c\t\u0003\u001f-L!\u0001\u001c\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006]\u001e\u0004\ra\\\u0001\u0010e\u00164WM]3oG\u0016<\u0016N\u001c3poB\u0019\u0001/\u001e=\u000f\u0005E\u001chB\u0001\u001cs\u0013\u0005\t\u0012B\u0001;\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0007M+\u0017O\u0003\u0002u!A\u0011Q#_\u0005\u0003uZ\u0011Q#T8oSR|'o\u00142kK\u000e$XI\u001c<fY>\u0004X\r\u0003\u0004}\u0001\u0001&I!`\u0001\f[\u0006\u00148nS3z'\u0016,g\u000e\u0006\u0003k}\u0006\u0005\u0001\"B@|\u0001\u0004\u0019\u0014aA6fs\"1\u00111A>A\u0002y\naa\u001c4gg\u0016$\b\u0002CA\u0004\u0001\u0001&I!!\u0003\u0002#1\f7\u000f^*fK:|eMZ:fi\u001a{'\u000fF\u0002?\u0003\u0017Aaa`A\u0003\u0001\u0004\u0019\u0004bBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\u0005M&tG\r\u0006\u0004\u0002\u0014\u0005e\u0011Q\u0004\t\u0004+\u0005U\u0011bAA\f-\t1Rj\u001c8ji>\u0014X*\u0019;dQ\u001aKg\u000e\u001a*fgVdG\u000fC\u0004\u0002\u001c\u00055\u0001\u0019\u0001=\u0002\u0017Q,7\u000f^'fgN\fw-\u001a\u0005\u0007]\u00065\u0001\u0019A8")
public class KeyEqualsFinder
implements MonitorMatchFinder,
StrictLogging {
    private final Map<String, Object> seenKeys;
    private final ReentrantReadWriteLock seenKeysLock;
    private Instant lastSeenKeysCleaning;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private String seenKeysKeyFor(Object input) {
        String string;
        Object object = input;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            MessageDigest shaDigester = MessageDigest.getInstance("SHA-1");
            byte[] shaBytes = shaDigester.digest(byArray);
            string = DatatypeConverter.printHexBinary((byte[])shaBytes);
        } else {
            String string2;
            string = object instanceof String ? (string2 = (String)object) : object.toString();
        }
        return string;
    }

    private boolean seenKeysNeedsCleaning() {
        return this.seenKeys.keySet().size() > 1000 && Instant.now().isAfter(this.lastSeenKeysCleaning.plusSeconds(300L));
    }

    private void pruneSeenKeys(Seq<MonitorObjectEnvelope> referenceWindow) {
        BoxedUnit boxedUnit;
        this.seenKeysLock.writeLock().lock();
        if (this.seenKeysNeedsCleaning() && referenceWindow.length() > 0) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Cleaning seen keys");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            long startOffset = ((MonitorObjectEnvelope)referenceWindow.head()).messageOffset();
            Set keysToRemove = ((MapLike)this.seenKeys.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KeyEqualsFinder.$anonfun$pruneSeenKeys$1(startOffset, x$1)))).keySet();
            keysToRemove.foreach((Function1 & Serializable & scala.Serializable)key -> $this.seenKeys.remove(key));
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Seen keys is clean");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.lastSeenKeysCleaning = Instant.now();
        this.seenKeysLock.writeLock().unlock();
    }

    private void markKeySeen(String key, long offset) {
        this.seenKeys.put((Object)key, (Object)BoxesRunTime.boxToLong((long)offset));
    }

    /*
     * WARNING - void declaration
     */
    private long lastSeenOffsetFor(String key) {
        void var2_2;
        this.seenKeysLock.readLock().lock();
        long lastSeenOffset = BoxesRunTime.unboxToLong((Object)this.seenKeys.get((Object)key).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        this.seenKeysLock.readLock().unlock();
        return (long)var2_2;
    }

    @Override
    public MonitorMatchFindResult find(MonitorObjectEnvelope testMessage, Seq<MonitorObjectEnvelope> referenceWindow) {
        if (this.seenKeysNeedsCleaning()) {
            this.pruneSeenKeys(referenceWindow);
        }
        String testRecordKey = this.seenKeysKeyFor(testMessage.keyInstance());
        long lastSeenOffsetOfKey = this.lastSeenOffsetFor(testRecordKey);
        return (MonitorMatchFindResult)referenceWindow.find((Function1 & Serializable & scala.Serializable)possibleMatch -> BoxesRunTime.boxToBoolean((boolean)KeyEqualsFinder.finder$1(possibleMatch, testMessage, lastSeenOffsetOfKey))).map((Function1 & Serializable & scala.Serializable)envelope -> {
            this.markKeySeen(testRecordKey, envelope.messageOffset());
            return envelope;
        }).map((Function1 & Serializable & scala.Serializable)x$2 -> new FoundMatch((MonitorObjectEnvelope)x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new NoMatchFound());
    }

    public static final /* synthetic */ boolean $anonfun$pruneSeenKeys$1(long startOffset$1, Tuple2 x$1) {
        return x$1._2$mcJ$sp() < startOffset$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean finder$1(MonitorObjectEnvelope possibleMatch, MonitorObjectEnvelope testMessage$1, long lastSeenOffsetOfKey$1) {
        Tuple2 tuple2 = new Tuple2(testMessage$1.keyInstance(), possibleMatch.keyInstance());
        if (possibleMatch.messageOffset() <= lastSeenOffsetOfKey$1) {
            return false;
        }
        if (tuple2 != null) {
            Object testKey = tuple2._1();
            Object possibleKey = tuple2._2();
            if (testKey instanceof byte[]) {
                byte[] byArray = (byte[])testKey;
                if (possibleKey instanceof byte[]) {
                    byte[] byArray2 = (byte[])possibleKey;
                    return Arrays.equals(byArray, byArray2);
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object testKey = tuple2._1();
        Object possibleKey = tuple2._2();
        return possibleKey.equals(testKey);
    }

    public KeyEqualsFinder() {
        StrictLogging.$init$((StrictLogging)this);
        this.seenKeys = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.seenKeysLock = new ReentrantReadWriteLock(true);
        this.lastSeenKeysCleaning = Instant.now();
    }
}

