/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import me.geso.avans.HTMLFilterProvider;
import me.geso.webscrew.response.ByteArrayResponse;
import me.geso.webscrew.response.WebResponse;

public class FreeMarkerView {
    private final Configuration configuration;
    private final Charset charset;
    private final String contentType;

    public FreeMarkerView(Configuration configuration, Charset charset, String contentType) {
        this.configuration = configuration;
        this.charset = charset;
        this.contentType = contentType;
    }

    public FreeMarkerView(Configuration configuration) {
        this(configuration, StandardCharsets.UTF_8, "text/html; charset=utf-8");
    }

    public WebResponse render(HTMLFilterProvider controller, @NonNull String templateName, Object dataModel) throws IOException, TemplateException {
        if (templateName == null) {
            throw new NullPointerException("templateName");
        }
        Template template = this.configuration.getTemplate(templateName);
        StringWriter writer = new StringWriter();
        template.process(dataModel, (Writer)writer);
        String bodyString = writer.toString();
        String filteredString = controller.filterHTML(bodyString);
        byte[] body = filteredString.getBytes(this.charset);
        ByteArrayResponse res = new ByteArrayResponse(200, body);
        res.setContentType(this.contentType);
        res.setContentLength((long)body.length);
        return res;
    }
}

