/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.jetty;

import javax.servlet.Servlet;
import me.geso.avans.AvansServlet;
import me.geso.avans.Controller;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServerBuilder {
    private int port = 80;
    private final AvansServlet servlet = new AvansServlet();
    private int minThreads = 80;
    private int maxThreads = 80;
    private boolean accessLogEnabled;

    public JettyServerBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public JettyServerBuilder registerPackage(Package pkg) {
        this.servlet.registerPackage(pkg);
        return this;
    }

    public JettyServerBuilder registerClass(Class<? extends Controller> klass) {
        this.servlet.registerClass(klass);
        return this;
    }

    public JettyServerBuilder enableAccessLog() {
        this.accessLogEnabled = true;
        return this;
    }

    public Server build() {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(this.minThreads, this.maxThreads);
        Server server = new Server((ThreadPool)queuedThreadPool);
        if (this.accessLogEnabled) {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setRequestLog((RequestLog)new Slf4jRequestLog());
            server.setHandler((Handler)requestLogHandler);
        }
        ServerConnector serverConnector = new ServerConnector(server);
        serverConnector.setPort(this.port);
        server.addConnector((Connector)serverConnector);
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.addServlet(servletHolder, "/*");
        server.setStopAtShutdown(true);
        return server;
    }

    public JettyServerBuilder setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public JettyServerBuilder setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }
}

