/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.jackson;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.IntStream;
import me.geso.avans.jackson.JacksonJsonParamReader;
import me.geso.avans.jackson.JacksonJsonViewBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.infra.Blackhole;

public class JacksonJsonParamReaderBenchmark {
    @Benchmark
    public void bench(Blackhole blackhole) throws Exception {
        String classFileName = "/" + this.getClass().getName().replaceAll("\\.", "/") + ".class";
        String classFilePath = this.getClass().getResource(classFileName).getFile().replaceAll("file:", "");
        File jarFilePath = new File(classFilePath.replaceFirst("!/.*$", ""));
        Path dataFilePath = Paths.get(jarFilePath.getParentFile().getParentFile() + "/src/main/resources/me/geso/avans/jackson/data1.json", new String[0]);
        File dataFile = dataFilePath.toFile();
        IntStream.rangeClosed(0, 10000).forEach(i -> {
            try (FileInputStream path = new FileInputStream(dataFile);){
                JacksonJsonParamReader sut = new JacksonJsonParamReader(){};
                blackhole.consume(sut.readJsonParam((InputStream)path, JacksonJsonViewBenchmark.JsonTest0.class));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }
}

