/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.mustache;

import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import me.geso.avans.HTMLFilterProvider;
import me.geso.webscrew.response.ByteArrayResponse;
import me.geso.webscrew.response.WebResponse;

public class MustacheView {
    private final MustacheFactory mustacheFactory;

    public MustacheView(MustacheFactory mustacheFactory) {
        this.mustacheFactory = mustacheFactory;
    }

    public WebResponse render(@NonNull HTMLFilterProvider controller, @NonNull String template, Object context) {
        if (controller == null) {
            throw new NullPointerException("controller");
        }
        if (template == null) {
            throw new NullPointerException("template");
        }
        Mustache mustache = this.mustacheFactory.compile(template);
        StringWriter writer = new StringWriter();
        mustache.execute((Writer)writer, context);
        String bodyString = writer.toString();
        bodyString = controller.filterHTML(bodyString);
        byte[] body = bodyString.getBytes(StandardCharsets.UTF_8);
        ByteArrayResponse res = new ByteArrayResponse(200, body);
        res.setContentType("text/html; charset=utf-8");
        res.setContentLength((long)body.length);
        return res;
    }
}

