/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.session;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.servlet.http.Cookie;
import lombok.NonNull;
import me.geso.avans.session.XSRFTokenCookieFactory;

public class DefaultXSRFTokenCookieFactory
implements XSRFTokenCookieFactory {
    private final String name;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    @NonNull
    private final Mac mac;
    private final int maxAge;

    @Override
    public Cookie createCookie(String string) {
        byte[] token;
        try {
            token = this.mac.doFinal(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalStateException e) {
            throw new RuntimeException(e);
        }
        String encoded = Base64.getUrlEncoder().encodeToString(token);
        Cookie cookie = new Cookie(this.name, encoded);
        cookie.setPath(this.path);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setSecure(this.secure);
        cookie.setMaxAge(this.maxAge);
        return cookie;
    }

    public static DefaultXSRFTokenCookieFactoryBuilder builder() {
        return new DefaultXSRFTokenCookieFactoryBuilder();
    }

    private DefaultXSRFTokenCookieFactory(String name, String path, boolean secure, boolean httpOnly, @NonNull Mac mac, int maxAge) {
        if (mac == null) {
            throw new NullPointerException("mac");
        }
        this.name = name;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.mac = mac;
        this.maxAge = maxAge;
    }

    public static class DefaultXSRFTokenCookieFactoryBuilder {
        private String name = "XSRF-TOKEN";
        private String path = "/";
        private boolean secure = false;
        private boolean httpOnly = false;
        @NonNull
        private Mac mac;
        private int maxAge = 86400;

        DefaultXSRFTokenCookieFactoryBuilder() {
        }

        public DefaultXSRFTokenCookieFactory build() {
            return new DefaultXSRFTokenCookieFactory(this.name, this.path, this.secure, this.httpOnly, this.mac, this.maxAge);
        }

        public DefaultXSRFTokenCookieFactoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DefaultXSRFTokenCookieFactoryBuilder path(String path) {
            this.path = path;
            return this;
        }

        public DefaultXSRFTokenCookieFactoryBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public DefaultXSRFTokenCookieFactoryBuilder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public DefaultXSRFTokenCookieFactoryBuilder mac(@NonNull Mac mac) {
            if (mac == null) {
                throw new NullPointerException("mac");
            }
            this.mac = mac;
            return this;
        }

        public DefaultXSRFTokenCookieFactoryBuilder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }
    }
}

