/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import me.geso.avans.session.SessionCookieFactory;
import me.geso.avans.session.SessionIDGenerator;
import me.geso.avans.session.WebSessionManager;
import me.geso.avans.session.WebSessionStore;
import me.geso.avans.session.XSRFTokenCookieFactory;
import me.geso.webscrew.response.WebResponse;

public class DefaultWebSessionManager
implements WebSessionManager {
    @NonNull
    private final HttpServletRequest request;
    @NonNull
    private final WebSessionStore sessionStore;
    @NonNull
    private final SessionCookieFactory sessionCookieFactory;
    @NonNull
    private final SessionIDGenerator sessionIDGenerator;
    @NonNull
    private final XSRFTokenCookieFactory xsrfTokenCookieFactory;
    private SessionData sessionData;
    private boolean expired = false;

    public DefaultWebSessionManager(HttpServletRequest request, WebSessionStore sessionStore, SessionIDGenerator sessionIDGenerator, SessionCookieFactory sessionCookieFactory, XSRFTokenCookieFactory xsrfTokenCookieFactory) {
        this.request = request;
        this.sessionStore = sessionStore;
        this.sessionIDGenerator = sessionIDGenerator;
        this.sessionCookieFactory = sessionCookieFactory;
        this.xsrfTokenCookieFactory = xsrfTokenCookieFactory;
    }

    private SessionData getSessionData() {
        if (this.expired) {
            throw new IllegalStateException("You can't call this method for expired session.");
        }
        if (this.sessionData == null) {
            Optional<SessionData> loadSession = this.loadSession();
            if (loadSession.isPresent()) {
                return loadSession.get();
            }
            String sessionId = this.generateSessionId();
            this.sessionData = SessionData.startNewSession(sessionId);
            return this.sessionData;
        }
        return this.sessionData;
    }

    private Optional<SessionData> loadSession() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String sessionId;
                Optional<Map<String, Object>> data;
                if (!this.sessionCookieFactory.getName().equals(cookie.getName()) || !(data = this.sessionStore.load(sessionId = cookie.getValue())).isPresent()) continue;
                this.sessionData = new SessionData(sessionId, data.get(), false);
                return Optional.of(this.sessionData);
            }
        }
        return Optional.empty();
    }

    @Override
    public String getSessionId() {
        return this.getSessionData().getSessionId();
    }

    private String generateSessionId() {
        return this.sessionIDGenerator.generate();
    }

    @Override
    public void setString(String key, String value) {
        this.getSessionData().setString(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.getSessionData().setLong(key, value);
    }

    @Override
    public Optional<String> getString(String key) {
        return this.getSessionData().getString(key);
    }

    @Override
    public OptionalLong getLong(String key) {
        return this.getSessionData().getLong(key);
    }

    @Override
    public void remove(String key) {
        this.getSessionData().remove(key);
    }

    @Override
    public boolean validateXSRFToken(String xsrfToken) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isFresh()) {
            return true;
        }
        if (null == xsrfToken) {
            return false;
        }
        return xsrfToken.equals(this.getXSRFToken());
    }

    @Override
    public void responseFilter(WebResponse response) {
        if (this.sessionData != null && (this.sessionData.isDirty() || this.sessionData.isFresh())) {
            this.sessionStore.save(this.sessionData.getSessionId(), this.sessionData.getData());
            Cookie sessionCookie = this.sessionCookieFactory.createCookie(this.sessionData.sessionId);
            response.addCookie(sessionCookie);
            Cookie xsrfTokenCookie = this.xsrfTokenCookieFactory.createCookie(this.sessionData.sessionId);
            response.addCookie(xsrfTokenCookie);
        }
    }

    @Override
    public String getXSRFToken() {
        return this.xsrfTokenCookieFactory.createXSRFToken(this.getSessionData().sessionId);
    }

    @Override
    public void expire() {
        this.sessionStore.remove(this.getSessionData().getSessionId());
        this.expired = true;
    }

    @Override
    public void changeSessionId() {
        HashMap<String, Object> data;
        Optional<SessionData> currentSession = this.loadSession();
        if (currentSession.isPresent()) {
            data = currentSession.get().getData();
            String sessionId = currentSession.get().getSessionId();
            this.sessionStore.remove(sessionId);
        } else {
            data = new HashMap();
        }
        String newSessionId = this.generateSessionId();
        this.sessionData = new SessionData(newSessionId, data, true);
        this.sessionData.setDirty();
    }

    private static class SessionData {
        private final String sessionId;
        private final Map<String, Object> data;
        private final boolean isFresh;
        private boolean isDirty;

        SessionData(String sessionId, @NonNull Map<String, Object> data, boolean isFresh) {
            if (data == null) {
                throw new NullPointerException("data");
            }
            this.sessionId = sessionId;
            this.data = data;
            this.isFresh = isFresh;
        }

        public static SessionData startNewSession(String sessionId) {
            return new SessionData(sessionId, new HashMap<String, Object>(), true);
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Optional<String> getString(String key) {
            if (this.data.containsKey(key)) {
                Object value = this.data.get(key);
                if (value instanceof String) {
                    return Optional.of((String)value);
                }
                throw new RuntimeException();
            }
            return Optional.empty();
        }

        public OptionalLong getLong(String key) {
            if (this.getData().containsKey(key)) {
                Object value = this.data.get(key);
                if (value instanceof Long) {
                    return OptionalLong.of((Long)value);
                }
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    return OptionalLong.of(i.longValue());
                }
                throw new RuntimeException(String.format("value for '%s' should be long. But: %s", key, value.getClass()));
            }
            return OptionalLong.empty();
        }

        public void setLong(String key, long value) {
            this.isDirty = true;
            this.getData().put(key, value);
        }

        public void setString(String key, String value) {
            this.isDirty = true;
            this.getData().put(key, value);
        }

        public void remove(String key) {
            this.getData().remove(key);
            this.isDirty = true;
        }

        public boolean isFresh() {
            return this.isFresh;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setDirty() {
            this.isDirty = true;
        }
    }
}

