/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.session;

import java.util.Optional;
import me.geso.avans.Controller;
import me.geso.avans.session.WebSessionManager;
import me.geso.avans.trigger.ResponseFilter;
import me.geso.webscrew.response.WebResponse;

public interface SessionMixin
extends Controller {
    public static final String stashKey = "session";

    default public WebSessionManager getSession() {
        Object session = this.computePluginStashValueIfAbsent(this.getClass(), stashKey, () -> this.buildSessionManager());
        return (WebSessionManager)session;
    }

    public WebSessionManager buildSessionManager();

    @ResponseFilter
    default public void responseFilter(WebResponse response) {
        Optional maybeSession = this.getPluginStashValue(this.getClass(), stashKey);
        if (maybeSession.isPresent()) {
            WebSessionManager session = (WebSessionManager)maybeSession.get();
            session.responseFilter(response);
        }
    }
}

