/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.session;

import javax.servlet.http.Cookie;
import lombok.NonNull;
import me.geso.avans.session.SessionCookieFactory;

public class DefaultSessionCookieFactory
implements SessionCookieFactory {
    @NonNull
    private final String name;
    @NonNull
    private final String path;
    private final boolean httpOnly;
    private final boolean secure;
    private final int maxAge;

    @Override
    public Cookie createCookie(String sessionId) {
        Cookie cookie = new Cookie(this.name, sessionId);
        cookie.setPath(this.path);
        cookie.setHttpOnly(this.httpOnly);
        cookie.setSecure(this.secure);
        cookie.setMaxAge(this.maxAge);
        return cookie;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static DefaultSessionCookieFactoryBuilder builder() {
        return new DefaultSessionCookieFactoryBuilder();
    }

    private DefaultSessionCookieFactory(@NonNull String name, @NonNull String path, boolean httpOnly, boolean secure, int maxAge) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.name = name;
        this.path = path;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.maxAge = maxAge;
    }

    public static class DefaultSessionCookieFactoryBuilder {
        @NonNull
        private String name = "avans_session_id";
        @NonNull
        private String path = "/";
        private boolean httpOnly = true;
        private boolean secure = false;
        private int maxAge = 86400;

        public DefaultSessionCookieFactory build() {
            return new DefaultSessionCookieFactory(this.name, this.path, this.httpOnly, this.secure, this.maxAge);
        }

        public DefaultSessionCookieFactoryBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public DefaultSessionCookieFactoryBuilder path(@NonNull String path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path = path;
            return this;
        }

        public DefaultSessionCookieFactoryBuilder httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public DefaultSessionCookieFactoryBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public DefaultSessionCookieFactoryBuilder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }
    }
}

