/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import me.geso.avans.Controller;
import me.geso.avans.FilterScanner;
import me.geso.avans.Filters;
import me.geso.avans.HTMLFilterProvider;
import me.geso.avans.JSONErrorPageRenderer;
import me.geso.avans.ParameterProcessorResult;
import me.geso.avans.TextRendererProvider;
import me.geso.avans.ValidatorProvider;
import me.geso.avans.annotation.BodyParam;
import me.geso.avans.annotation.JsonParam;
import me.geso.avans.annotation.PathParam;
import me.geso.avans.annotation.QueryParam;
import me.geso.avans.annotation.UploadFile;
import me.geso.avans.jackson.JacksonJsonParamReader;
import me.geso.avans.jackson.JacksonJsonView;
import me.geso.avans.trigger.ParamProcessor;
import me.geso.avans.trigger.ResponseConverter;
import me.geso.webscrew.Parameters;
import me.geso.webscrew.request.WebRequest;
import me.geso.webscrew.request.WebRequestUpload;
import me.geso.webscrew.request.impl.DefaultParameters;
import me.geso.webscrew.request.impl.DefaultWebRequest;
import me.geso.webscrew.response.ByteArrayResponse;
import me.geso.webscrew.response.RedirectResponse;
import me.geso.webscrew.response.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControllerBase
implements Controller,
JacksonJsonView,
HTMLFilterProvider,
JSONErrorPageRenderer,
ValidatorProvider,
TextRendererProvider,
JacksonJsonParamReader {
    private WebRequest request;
    private HttpServletResponse servletResponse;
    private Parameters pathParameters;
    private final Map<String, Object> pluginStash = new HashMap<String, Object>();
    private static final Logger logger = LoggerFactory.getLogger(ControllerBase.class);
    private static final Logger exceptionRootCauseLogger = LoggerFactory.getLogger((String)"avans.exception.RootCause");
    private static final Logger exceptionStackTraceLogger = LoggerFactory.getLogger((String)"avans.exception.StackTrace");
    final ConcurrentHashMap<Class<?>, Filters> filters = new ConcurrentHashMap();

    @Override
    public void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map<String, String> captured) {
        this.request = this.createWebReqeust(servletRequest);
        this.servletResponse = servletResponse;
        this.setDefaultCharacterEncoding();
        DefaultParameters.Builder pathParameters = DefaultParameters.builder();
        for (Map.Entry<String, String> entry : captured.entrySet()) {
            pathParameters.put(entry.getKey(), entry.getValue());
        }
        this.pathParameters = pathParameters.build();
    }

    public WebRequest createWebReqeust(HttpServletRequest servletRequest) {
        try {
            return new DefaultWebRequest(servletRequest, StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDefaultCharacterEncoding() {
        this.servletResponse.setCharacterEncoding("UTF-8");
    }

    @Override
    public WebRequest getRequest() {
        return this.request;
    }

    @Override
    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    public RedirectResponse redirect(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        return new RedirectResponse(location);
    }

    public WebResponse errorMethodNotAllowed() {
        return this.renderError(405, "Method Not Allowed");
    }

    public WebResponse errorForbidden() {
        return this.errorForbidden("Forbidden");
    }

    public WebResponse errorForbidden(String message) {
        return this.renderError(403, message);
    }

    public WebResponse errorNotFound() {
        return this.renderError(404, "Not Found");
    }

    @Override
    public WebResponse renderText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        ByteArrayResponse res = new ByteArrayResponse(200, bytes);
        res.setContentType("text/plain; charset=utf-8");
        return res;
    }

    @Override
    public String filterHTML(String html) {
        String h = html;
        for (Method filter : this.getFilters().getHtmlFilters()) {
            try {
                h = (String)filter.invoke((Object)this, h);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return h;
    }

    @Override
    public void invoke(Method method, HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map<String, String> captured) {
        try {
            this.init(servletRequest, servletResponse, captured);
            WebResponse response = this.makeResponse(this, method);
            for (Method filter : this.getFilters().getResponseFilters()) {
                filter.invoke((Object)this, response);
            }
            response.write(servletResponse);
        }
        catch (Throwable e) {
            WebResponse response = this.handleException(e);
            try {
                response.write(servletResponse);
            }
            catch (IOException ioe) {
                this.logException(ioe);
                throw new RuntimeException(ioe);
            }
        }
    }

    private void logException(Throwable e) {
        Throwable root = this.unwrapRuntimeException(e);
        StackTraceElement[] stackTrace = root.getStackTrace();
        if (stackTrace.length > 0) {
            StackTraceElement ste = stackTrace[0];
            exceptionRootCauseLogger.error("{}, {}, {}, {}, {}: {} at {}.{}({}:{})", new Object[]{this.getRequest().getMethod(), this.getRequest().getPathInfo(), this.getRequest().getUserAgent(), this.getRequest().getRemoteAddr(), root.getClass(), root.getMessage(), ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber()});
        } else {
            exceptionRootCauseLogger.error("{}, {}, {}, {}, {}: {}", new Object[]{this.getRequest().getMethod(), this.getRequest().getPathInfo(), this.getRequest().getUserAgent(), this.getRequest().getRemoteAddr(), root.getClass(), root.getMessage()});
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        String s = writer.toString();
        exceptionStackTraceLogger.error("{}: {}\n{}", new Object[]{root.getClass(), root.getMessage(), s});
    }

    public WebResponse handleException(Throwable e) {
        this.logException(e);
        return this.renderError(500, "Internal Server Error");
    }

    private Throwable unwrapRuntimeException(Throwable e) {
        while ((e instanceof RuntimeException || e instanceof InvocationTargetException) && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    Filters getFilters() {
        return this.filters.computeIfAbsent(this.getClass(), klass -> {
            FilterScanner scanner = new FilterScanner();
            scanner.scan((Class<?>)klass);
            return scanner.build();
        });
    }

    private WebResponse makeResponse(Controller controller, Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object res;
        for (Method filter : this.getFilters().getBeforeDispatchTriggers()) {
            try {
                Optional webResponse = (Optional)filter.invoke((Object)this, new Object[0]);
                if (webResponse == null) {
                    throw new NullPointerException("@BeforeDispatchTrigger shouldn't returned null. It should return `Optional<WebResponse>`.");
                }
                if (!webResponse.isPresent()) continue;
                return (WebResponse)webResponse.get();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        Parameter[] parameters = method.getParameters();
        Object[] params = new Object[parameters.length];
        ArrayList<String> violationMessages = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            ParameterProcessorResult value = this.getParameterValue(parameter);
            if (value.hasResponse()) {
                return value.getResponse();
            }
            if (value.hasData()) {
                params[i] = value.getData();
                continue;
            }
            violationMessages.add(String.format("Missing mandatory parameter: %s", value.getMissingParameter()));
        }
        Optional<WebResponse> validationResult = this.validateParameters(method, params);
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        try {
            res = method.invoke((Object)controller, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error("{}: {}: {}, {}", new Object[]{e, this.request.getPathInfo(), controller, params});
            throw new RuntimeException(e);
        }
        if (res instanceof WebResponse) {
            return (WebResponse)res;
        }
        if (res == null) {
            throw new RuntimeException("dispatch method must not return NULL");
        }
        for (Method converter : this.getFilters().getResponseConverters()) {
            ResponseConverter annotation = converter.getAnnotation(ResponseConverter.class);
            if (!res.getClass().isAssignableFrom(annotation.value())) continue;
            Object v = converter.invoke((Object)this, res);
            if (v == null) {
                throw new NullPointerException("@ResponseConverter must not return NULL");
            }
            if (v instanceof Optional) {
                Optional ov = (Optional)v;
                if (!ov.isPresent()) continue;
                WebResponse response = (WebResponse)ov.get();
                return response;
            }
            throw new RuntimeException("@ResponseConverter must return Optional<WebResponse>");
        }
        throw new RuntimeException(String.format("Unknown return value from action: %s(%s)", res.getClass(), this.getRequest().getPathInfo()));
    }

    private <T> ParameterProcessorResult getParameterValue(Parameter parameter) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method pp : this.getFilters().getParamProcessors()) {
            ParamProcessor paramProcessor = pp.getAnnotation(ParamProcessor.class);
            if (!paramProcessor.targetClass().isAssignableFrom(parameter.getType()) || paramProcessor.targetAnnotation() != ParamProcessor.class && parameter.getAnnotation(paramProcessor.targetAnnotation()) == null) continue;
            Object result = pp.invoke((Object)this, parameter);
            if (result == null) {
                throw new NullPointerException("@ParamProcessor returns null: " + pp);
            }
            if (result instanceof ParameterProcessorResult) {
                if (!((ParameterProcessorResult)result).hasData() && !((ParameterProcessorResult)result).hasResponse()) continue;
                return (ParameterProcessorResult)result;
            }
            throw new RuntimeException("@ParamProcessor should return ParameterProcessorResult, but " + pp);
        }
        Annotation[] annotations = parameter.getAnnotations();
        Class<?> type = parameter.getType();
        for (Annotation annotation : annotations) {
            if (annotation instanceof JsonParam) {
                try {
                    InputStream is = this.getRequest().getInputStream();
                    Object value = this.readJsonParam(is, type);
                    return ParameterProcessorResult.fromData(value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (annotation instanceof QueryParam) {
                String name = ((QueryParam)annotation).value();
                return this.getObjectFromParameterObject(annotation, name, type, this.getRequest().getQueryParams());
            }
            if (annotation instanceof BodyParam) {
                String name = ((BodyParam)annotation).value();
                return this.getObjectFromParameterObject(annotation, name, type, this.getRequest().getBodyParams());
            }
            if (annotation instanceof PathParam) {
                String name = ((PathParam)annotation).value();
                return this.getObjectFromParameterObject(annotation, name, type, this.getPathParameters());
            }
            if (!(annotation instanceof UploadFile)) continue;
            String name = ((UploadFile)annotation).value();
            if (type == WebRequestUpload.class) {
                Optional maybeFileItem = this.getRequest().getFirstFileItem(name);
                return ParameterProcessorResult.fromData(maybeFileItem.get());
            }
            if (type == WebRequestUpload[].class) {
                WebRequestUpload[] items = this.getRequest().getAllFileItems(name).toArray(new WebRequestUpload[0]);
                return ParameterProcessorResult.fromData(items);
            }
            if (type == Optional.class) {
                Optional maybeFileItem = this.getRequest().getFirstFileItem(name);
                return ParameterProcessorResult.fromData(maybeFileItem);
            }
            throw new RuntimeException(String.format("You shouldn't use @UploadFile annotation with %s. You must use FileItem or FileItem[]", type));
        }
        throw new RuntimeException(String.format("There is no way to create parameter: %s, %s, %s", this.getClass().getName(), this.getRequest().getPathInfo(), parameter.getName()));
    }

    private ParameterProcessorResult getObjectFromParameterObject(Annotation annotation, String name, Class<?> type, Parameters params) {
        if (type.equals(String.class)) {
            Optional value = params.getFirst(name);
            if (!value.isPresent()) {
                return ParameterProcessorResult.missingParameter(name);
            }
            return ParameterProcessorResult.fromData(value.get());
        }
        if (type.equals(Integer.TYPE)) {
            Optional value = params.getFirst(name);
            if (!value.isPresent()) {
                return ParameterProcessorResult.missingParameter(name);
            }
            return ParameterProcessorResult.fromData(Integer.parseInt((String)value.get()));
        }
        if (type.equals(Long.TYPE)) {
            Optional value = params.getFirst(name);
            if (!value.isPresent()) {
                return ParameterProcessorResult.missingParameter(name);
            }
            return ParameterProcessorResult.fromData(Long.parseLong((String)value.get()));
        }
        if (type.equals(Double.TYPE)) {
            Optional value = params.getFirst(name);
            if (!value.isPresent()) {
                return ParameterProcessorResult.missingParameter(name);
            }
            return ParameterProcessorResult.fromData(Double.parseDouble((String)value.get()));
        }
        if (type.equals(OptionalInt.class)) {
            Optional value = params.getFirst(name);
            if (value.isPresent()) {
                return ParameterProcessorResult.fromData(OptionalInt.of(Integer.parseInt((String)value.get())));
            }
            return ParameterProcessorResult.fromData(OptionalInt.empty());
        }
        if (type.equals(OptionalLong.class)) {
            Optional value = params.getFirst(name);
            if (value.isPresent()) {
                return ParameterProcessorResult.fromData(OptionalLong.of(Long.parseLong((String)value.get())));
            }
            return ParameterProcessorResult.fromData(OptionalLong.empty());
        }
        if (type.equals(OptionalDouble.class)) {
            Optional value = params.getFirst(name);
            if (value.isPresent()) {
                return ParameterProcessorResult.fromData(OptionalDouble.of(Double.parseDouble((String)value.get())));
            }
            return ParameterProcessorResult.fromData(OptionalDouble.empty());
        }
        if (type.equals(Optional.class)) {
            Optional value = params.getFirst(name);
            if (value.isPresent()) {
                return ParameterProcessorResult.fromData(Optional.of(value.get()));
            }
            return ParameterProcessorResult.fromData(Optional.empty());
        }
        throw new RuntimeException(String.format("Unknown parameter type '%s' for '%s'", type, name));
    }

    @Override
    public void close() {
    }

    private String generatePluginStashKey(Class<?> pluginClass, String key) {
        return pluginClass.getName() + "#" + key;
    }

    @Override
    public Optional<Object> getPluginStashValue(Class<?> pluginClass, String key) {
        Object object = this.pluginStash.get(this.generatePluginStashKey(pluginClass, key));
        return Optional.ofNullable(object);
    }

    @Override
    public void setPluginStashValue(Class<?> pluginClass, String key, Object value) {
        this.pluginStash.put(this.generatePluginStashKey(pluginClass, key), value);
    }

    @Override
    public Object computePluginStashValueIfAbsent(Class<?> pluginClass, String key, Supplier<?> supplier) {
        return this.pluginStash.computeIfAbsent(this.generatePluginStashKey(pluginClass, key), fullKey -> supplier.get());
    }
}

