/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import me.geso.avans.JSONParamReader;
import org.apache.commons.io.IOUtils;

public interface JacksonJsonParamReader
extends JSONParamReader {
    @Override
    default public Object readJsonParam(InputStream is, Class<?> valueType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        byte[] byteArray = IOUtils.toByteArray((InputStream)is);
        try {
            Object value = mapper.readValue(byteArray, valueType);
            return value;
        }
        catch (JsonParseException | JsonMappingException e) {
            String json = new String(byteArray, StandardCharsets.UTF_8);
            Throwable cause = e.getCause();
            throw new IOException((cause != null ? cause.getMessage() : e.getMessage()) + " : " + json);
        }
    }
}

