/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.geso.avans.Controller;
import me.geso.avans.annotation.GET;
import me.geso.avans.annotation.POST;
import me.geso.routes.RoutingResult;
import me.geso.routes.WebRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Dispatcher.class);
    private final WebRouter<Action> router = new WebRouter();

    public void registerPackage(Package pkg) {
        this.registerPackage(pkg.getName());
    }

    public void registerPackage(String packageName) {
        ImmutableSet topLevelClasses;
        LOGGER.info("Registering package: {}", (Object)packageName);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            topLevelClasses = ClassPath.from((ClassLoader)contextClassLoader).getTopLevelClasses(packageName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (ClassPath.ClassInfo classInfo : topLevelClasses) {
            Class klass = classInfo.load();
            if (Controller.class.isAssignableFrom(klass)) {
                Class<Controller> pagesClass = klass.asSubclass(Controller.class);
                this.registerClass(pagesClass);
                continue;
            }
            LOGGER.info("{} is not a Controller", (Object)klass);
        }
    }

    public void registerClass(Class<? extends Controller> klass) {
        try {
            LOGGER.info("Registering class: {}", klass);
            for (Method method : klass.getMethods()) {
                GET get;
                Action action;
                String path;
                POST post = method.getAnnotation(POST.class);
                if (post != null) {
                    path = post.value();
                    action = new Action(klass, method);
                    LOGGER.info("POST {}", (Object)path);
                    this.router.post(path, (Object)action);
                }
                if ((get = method.getAnnotation(GET.class)) == null) continue;
                path = get.value();
                action = new Action(klass, method);
                LOGGER.info("GET {}", (Object)path);
                this.router.get(path, (Object)action);
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void handler(HttpServletRequest request, HttpServletResponse response) {
        String path;
        String method = request.getMethod();
        RoutingResult match = this.router.match(method, path = request.getPathInfo());
        if (match == null) {
            this.writeNotFoundErrorPage(response);
            return;
        }
        if (!match.methodAllowed()) {
            this.writeMethodNotAllowedErrorPage(response);
            return;
        }
        Map captured = match.getCaptured();
        Action action = (Action)match.getDestination();
        this.runController(action.getControllerClass(), action.getMethod(), request, response, captured);
    }

    public void runController(Class<? extends Controller> controllerClass, Method method, HttpServletRequest request, HttpServletResponse response, Map<String, String> captured) {
        try (Controller controller = this.buildController(controllerClass);){
            controller.invoke(method, request, response, captured);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Controller buildController(Class<? extends Controller> controllerClass) throws InstantiationException, IllegalAccessException {
        return controllerClass.newInstance();
    }

    private void writeMethodNotAllowedErrorPage(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setStatus(405);
        response.setContentType("text/html; charset=utf-8");
        try {
            response.getWriter().write("<!doctype html><html><div style='font-size: 400%'>405 Method Not Allowed</div></html>");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeNotFoundErrorPage(HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setStatus(404);
        response.setContentType("text/html; charset=utf-8");
        try {
            response.getWriter().write("<!doctype html><html><div style='font-size: 400%'>404 Not Found</div></html>");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WebRouter<Action> getRouter() {
        return this.router;
    }

    public static class Action {
        private final Class<? extends Controller> controllerClass;
        private final Method method;

        public Action(Class<? extends Controller> controllerClass, Method method) {
            this.controllerClass = controllerClass;
            this.method = method;
        }

        public Class<? extends Controller> getControllerClass() {
            return this.controllerClass;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

