/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import lombok.NonNull;
import me.geso.avans.Controller;
import me.geso.avans.FilterScanner;
import me.geso.avans.Filters;
import me.geso.avans.HTMLFilterProvider;
import me.geso.avans.JSONErrorPageRenderer;
import me.geso.avans.ParameterProcessorResult;
import me.geso.avans.TextRendererProvider;
import me.geso.avans.ValidatorProvider;
import me.geso.avans.annotation.BeanParam;
import me.geso.avans.annotation.JsonParam;
import me.geso.avans.annotation.Param;
import me.geso.avans.annotation.PathParam;
import me.geso.avans.annotation.UploadFile;
import me.geso.avans.jackson.JacksonJsonParamReader;
import me.geso.avans.jackson.JacksonJsonView;
import me.geso.avans.trigger.ParamProcessor;
import me.geso.avans.trigger.ResponseConverter;
import me.geso.webscrew.response.ByteArrayResponse;
import me.geso.webscrew.response.RedirectResponse;
import me.geso.webscrew.response.WebResponse;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ControllerBase
implements Controller,
JacksonJsonView,
HTMLFilterProvider,
JSONErrorPageRenderer,
ValidatorProvider,
TextRendererProvider,
JacksonJsonParamReader {
    private static final Logger log = LoggerFactory.getLogger(ControllerBase.class);
    private HttpServletResponse servletResponse;
    private final Map<String, Object> pluginStash = new HashMap<String, Object>();
    private HttpServletRequest servletRequest;
    private Map<String, String> pathParams;
    private static final Logger logger = LoggerFactory.getLogger(ControllerBase.class);
    private static final Logger exceptionRootCauseLogger = LoggerFactory.getLogger((String)"avans.exception.RootCause");
    private static final Logger exceptionStackTraceLogger = LoggerFactory.getLogger((String)"avans.exception.StackTrace");
    final ConcurrentHashMap<Class<?>, Filters> filters = new ConcurrentHashMap();

    @Override
    public void init(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map<String, String> captured) {
        this.servletResponse = servletResponse;
        this.servletRequest = servletRequest;
        this.setDefaultCharacterEncoding();
        this.pathParams = Collections.unmodifiableMap(captured);
    }

    private void setDefaultCharacterEncoding() {
        this.servletResponse.setCharacterEncoding("UTF-8");
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public RedirectResponse redirect(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location");
        }
        return new RedirectResponse(location);
    }

    public RedirectResponse redirect(@NonNull String location, @NonNull Map<String, String> parameters) throws URISyntaxException {
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        URIBuilder uriBuilder = new URIBuilder(location);
        parameters.entrySet().stream().forEach(e -> uriBuilder.setParameter((String)e.getKey(), (String)e.getValue()));
        return new RedirectResponse(uriBuilder.build().toString());
    }

    public WebResponse errorMethodNotAllowed() {
        return this.renderError(405, "Method Not Allowed");
    }

    public WebResponse errorForbidden() {
        return this.errorForbidden("Forbidden");
    }

    public WebResponse errorForbidden(String message) {
        return this.renderError(403, message);
    }

    public WebResponse errorNotFound() {
        return this.renderError(404, "Not Found");
    }

    @Override
    public WebResponse renderText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        ByteArrayResponse res = new ByteArrayResponse(200, bytes);
        res.setContentType("text/plain; charset=utf-8");
        return res;
    }

    @Override
    public String filterHTML(String html) {
        String h = html;
        for (Method filter : this.getFilters().getHtmlFilters()) {
            try {
                h = (String)filter.invoke((Object)this, h);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return h;
    }

    @Override
    public void invoke(Method method, HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map<String, String> captured) {
        try {
            this.init(servletRequest, servletResponse, captured);
            WebResponse response = this.makeResponse(this, method);
            for (Method filter : this.getFilters().getResponseFilters()) {
                filter.invoke((Object)this, response);
            }
            response.write(servletResponse);
        }
        catch (Throwable e) {
            WebResponse response = this.handleException(e);
            try {
                response.write(servletResponse);
            }
            catch (IOException ioe) {
                this.logException(ioe);
                throw new RuntimeException(ioe);
            }
        }
    }

    private void logException(Throwable e) {
        Throwable root = this.unwrapRuntimeException(e);
        StackTraceElement[] stackTrace = root.getStackTrace();
        if (stackTrace.length > 0) {
            StackTraceElement ste = stackTrace[0];
            exceptionRootCauseLogger.error("{}, {}, {}, {}, {}: {} at {}.{}({}:{})", new Object[]{this.servletRequest.getMethod(), this.servletRequest.getPathInfo(), this.servletRequest.getHeader("User-Agent"), this.servletRequest.getRemoteAddr(), root.getClass(), root.getMessage(), ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber()});
        } else {
            exceptionRootCauseLogger.error("{}, {}, {}, {}, {}: {}", new Object[]{this.servletRequest.getMethod(), this.servletRequest.getPathInfo(), this.servletRequest.getHeader("User-Agent"), this.servletRequest.getRemoteAddr(), root.getClass(), root.getMessage()});
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        String s = writer.toString();
        exceptionStackTraceLogger.error("{}: {}\n{}", new Object[]{root.getClass(), root.getMessage(), s});
    }

    public WebResponse handleException(Throwable e) {
        this.logException(e);
        return this.renderError(500, "Internal Server Error");
    }

    private Throwable unwrapRuntimeException(Throwable e) {
        while ((e instanceof RuntimeException || e instanceof InvocationTargetException) && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    Filters getFilters() {
        return this.filters.computeIfAbsent(this.getClass(), klass -> {
            FilterScanner scanner = new FilterScanner();
            scanner.scan((Class<?>)klass);
            return scanner.build();
        });
    }

    private WebResponse makeResponse(Controller controller, Method method) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, ServletException, InstantiationException {
        Object res;
        for (Method filter : this.getFilters().getBeforeDispatchTriggers()) {
            try {
                Optional webResponse = (Optional)filter.invoke((Object)this, new Object[0]);
                if (webResponse == null) {
                    throw new NullPointerException("@BeforeDispatchTrigger shouldn't returned null. It should return `Optional<WebResponse>`.");
                }
                if (!webResponse.isPresent()) continue;
                return (WebResponse)webResponse.get();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        Parameter[] parameters = method.getParameters();
        Object[] params = new Object[parameters.length];
        ArrayList<String> missingParameters = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (parameter.getAnnotation(BeanParam.class) != null) {
                Field[] declaredFields = parameter.getType().getDeclaredFields();
                Object bean = parameter.getType().newInstance();
                for (Field field : declaredFields) {
                    ParameterProcessorResult value = this.getParameterValue(field, field.getType(), field.getName());
                    if (value.hasResponse()) {
                        return value.getResponse();
                    }
                    if (value.hasData()) {
                        field.setAccessible(true);
                        field.set(bean, value.getData());
                        continue;
                    }
                    missingParameters.add(value.getMissingParameter());
                }
                params[i] = bean;
                continue;
            }
            ParameterProcessorResult value = this.getParameterValue(parameter, parameter.getType(), parameter.getName());
            if (value.hasResponse()) {
                return value.getResponse();
            }
            if (value.hasData()) {
                params[i] = value.getData();
                continue;
            }
            missingParameters.add(value.getMissingParameter());
        }
        if (!missingParameters.isEmpty()) {
            return this.errorMissingMandatoryParameters(missingParameters);
        }
        Optional<WebResponse> validationResult = this.validateParameters(method, params);
        if (validationResult.isPresent()) {
            return validationResult.get();
        }
        try {
            res = method.invoke((Object)controller, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            logger.error("{}: {}: {}, {}", new Object[]{e, this.getServletRequest().getPathInfo(), controller, params});
            throw new RuntimeException(e);
        }
        if (res instanceof WebResponse) {
            return (WebResponse)res;
        }
        if (res == null) {
            throw new RuntimeException("dispatch method must not return NULL");
        }
        for (Method converter : this.getFilters().getResponseConverters()) {
            ResponseConverter annotation = converter.getAnnotation(ResponseConverter.class);
            if (!res.getClass().isAssignableFrom(annotation.value())) continue;
            Object v = converter.invoke((Object)this, res);
            if (v == null) {
                throw new NullPointerException("@ResponseConverter must not return NULL");
            }
            if (v instanceof Optional) {
                Optional ov = (Optional)v;
                if (!ov.isPresent()) continue;
                WebResponse response = (WebResponse)ov.get();
                return response;
            }
            throw new RuntimeException("@ResponseConverter must return Optional<WebResponse>");
        }
        throw new RuntimeException(String.format("Unknown return value from action: %s(%s)", res.getClass(), this.servletRequest.getPathInfo()));
    }

    protected WebResponse errorMissingMandatoryParameters(List<String> missingParameters) {
        int BAD_REQUEST = 400;
        StringBuilder buf = new StringBuilder();
        buf.append("Missing mandatory parameter: ");
        buf.append(missingParameters.stream().collect(Collectors.joining(", ")));
        return this.renderError(400, new String(buf));
    }

    private <T> ParameterProcessorResult getParameterValue(AnnotatedElement parameter, Class<?> type, String parameterName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException, ServletException, InstantiationException {
        Annotation[] annotations;
        for (Method pp : this.getFilters().getParamProcessors()) {
            ParamProcessor paramProcessor = pp.getAnnotation(ParamProcessor.class);
            if (!paramProcessor.targetClass().isAssignableFrom(type) || paramProcessor.targetAnnotation() != ParamProcessor.class && parameter.getAnnotation(paramProcessor.targetAnnotation()) == null) continue;
            Object result = pp.invoke((Object)this, parameter);
            if (result == null) {
                throw new NullPointerException("@ParamProcessor returns null: " + pp);
            }
            if (result instanceof ParameterProcessorResult) {
                if (!((ParameterProcessorResult)result).hasData() && !((ParameterProcessorResult)result).hasResponse()) continue;
                return (ParameterProcessorResult)result;
            }
            throw new RuntimeException("@ParamProcessor should return ParameterProcessorResult, but " + pp);
        }
        for (Annotation annotation : annotations = parameter.getAnnotations()) {
            if (annotation instanceof JsonParam) {
                ServletInputStream is = this.servletRequest.getInputStream();
                Object value = this.readJsonParam((InputStream)is, type);
                return ParameterProcessorResult.fromData(value);
            }
            if (annotation instanceof Param) {
                String name = ((Param)annotation).value();
                String value = this.getServletRequest().getParameter(name);
                return this.getObjectFromParameterObjectValue(annotation, name, type, value);
            }
            if (annotation instanceof PathParam) {
                String name = ((PathParam)annotation).value();
                String value = this.pathParams.get(name);
                return this.getObjectFromParameterObjectValue(annotation, name, type, value);
            }
            if (!(annotation instanceof UploadFile)) continue;
            String name = ((UploadFile)annotation).value();
            if (type == Part.class) {
                Part part2 = this.servletRequest.getPart(name);
                if (part2 != null) {
                    return ParameterProcessorResult.fromData(part2);
                }
                return ParameterProcessorResult.missingParameter(name);
            }
            if (type == Part[].class) {
                Part[] parts = (Part[])this.servletRequest.getParts().stream().filter(part -> name.equals(part.getName())).toArray(Part[]::new);
                return ParameterProcessorResult.fromData(parts);
            }
            if (type == Optional.class) {
                try {
                    Part part3 = this.servletRequest.getPart(name);
                    if (part3 != null) {
                        return ParameterProcessorResult.fromData(Optional.of(part3));
                    }
                    return ParameterProcessorResult.fromData(Optional.empty());
                }
                catch (IOException e) {
                    log.info("{}: {}", e.getClass(), (Object)e.getMessage());
                    return ParameterProcessorResult.fromData(Optional.empty());
                }
            }
            throw new RuntimeException(String.format("You shouldn't use @UploadFile annotation with %s. You must use Part or Part[]", type));
        }
        throw new RuntimeException(String.format("There is no way to create parameter: %s, %s, %s", this.getClass().getName(), this.getServletRequest().getPathInfo(), parameterName));
    }

    private ParameterProcessorResult getObjectFromParameterObjectValue(Annotation annotation, String name, Class<?> type, String value) {
        if (type.equals(String.class)) {
            if (value != null) {
                return ParameterProcessorResult.fromData(value);
            }
            return ParameterProcessorResult.missingParameter(name);
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            if (value != null) {
                return ParameterProcessorResult.fromData(Integer.parseInt(value));
            }
            return ParameterProcessorResult.missingParameter(name);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            if (value != null) {
                return ParameterProcessorResult.fromData(Long.parseLong(value));
            }
            return ParameterProcessorResult.missingParameter(name);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            if (value != null) {
                return ParameterProcessorResult.fromData(Short.parseShort(value));
            }
            return ParameterProcessorResult.missingParameter(name);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            if (value != null) {
                return ParameterProcessorResult.fromData(Double.parseDouble(value));
            }
            return ParameterProcessorResult.missingParameter(name);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            if (value != null) {
                return ParameterProcessorResult.fromData(Boolean.parseBoolean(value));
            }
            return ParameterProcessorResult.missingParameter(name);
        }
        if (type.equals(OptionalInt.class)) {
            if (value != null && !value.isEmpty()) {
                return ParameterProcessorResult.fromData(OptionalInt.of(Integer.parseInt(value)));
            }
            return ParameterProcessorResult.fromData(OptionalInt.empty());
        }
        if (type.equals(OptionalLong.class)) {
            if (value != null && !value.isEmpty()) {
                return ParameterProcessorResult.fromData(OptionalLong.of(Long.parseLong(value)));
            }
            return ParameterProcessorResult.fromData(OptionalLong.empty());
        }
        if (type.equals(OptionalDouble.class)) {
            if (value != null && !value.isEmpty()) {
                return ParameterProcessorResult.fromData(OptionalDouble.of(Double.parseDouble(value)));
            }
            return ParameterProcessorResult.fromData(OptionalDouble.empty());
        }
        if (type.equals(Optional.class)) {
            if (value != null && !value.isEmpty()) {
                return ParameterProcessorResult.fromData(Optional.of(value));
            }
            return ParameterProcessorResult.fromData(Optional.empty());
        }
        throw new RuntimeException(String.format("Unknown parameter type '%s' for '%s'", type, name));
    }

    @Override
    public void close() {
    }

    private String generatePluginStashKey(Class<?> pluginClass, String key) {
        return pluginClass.getName() + "#" + key;
    }

    @Override
    public Optional<Object> getPluginStashValue(Class<?> pluginClass, String key) {
        Object object = this.pluginStash.get(this.generatePluginStashKey(pluginClass, key));
        return Optional.ofNullable(object);
    }

    @Override
    public void setPluginStashValue(Class<?> pluginClass, String key, Object value) {
        this.pluginStash.put(this.generatePluginStashKey(pluginClass, key), value);
    }

    @Override
    public Object computePluginStashValueIfAbsent(Class<?> pluginClass, String key, Supplier<?> supplier) {
        return this.pluginStash.computeIfAbsent(this.generatePluginStashKey(pluginClass, key), fullKey -> supplier.get());
    }

    @Override
    public Map<String, String> getPathParams() {
        return this.pathParams;
    }
}

