/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import me.geso.avans.ControllerBase;
import me.geso.avans.Filters;
import me.geso.avans.trigger.BeforeDispatchTrigger;
import me.geso.avans.trigger.HTMLFilter;
import me.geso.avans.trigger.ParamProcessor;
import me.geso.avans.trigger.ResponseConverter;
import me.geso.avans.trigger.ResponseFilter;

class FilterScanner {
    private final List<Method> responseFilters = new ArrayList<Method>();
    private final List<Method> htmlFilters = new ArrayList<Method>();
    private final List<Method> beforeDispatchTriggers = new ArrayList<Method>();
    private final List<Method> responseConverters = new ArrayList<Method>();
    private final List<Method> paramProcessors = new ArrayList<Method>();
    private final Set<Method> seen = new HashSet<Method>();

    FilterScanner() {
    }

    void scanMethod(Method method) {
        if (this.seen.contains(method)) {
            return;
        }
        if (method.getAnnotation(BeforeDispatchTrigger.class) != null) {
            this.beforeDispatchTriggers.add(method);
        }
        if (method.getAnnotation(HTMLFilter.class) != null) {
            this.htmlFilters.add(method);
        }
        if (method.getAnnotation(ResponseFilter.class) != null) {
            this.responseFilters.add(method);
        }
        if (method.getAnnotation(ResponseConverter.class) != null) {
            this.responseConverters.add(method);
        }
        if (method.getAnnotation(ParamProcessor.class) != null) {
            this.paramProcessors.add(method);
        }
        this.seen.add(method);
    }

    public void scan(Class<?> klass) {
        LinkedList linearIsa = new LinkedList();
        while (klass != null && klass != ControllerBase.class) {
            linearIsa.addFirst(klass);
            klass = klass.getSuperclass();
        }
        for (Class clazz : linearIsa) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                for (Method method : clazz2.getMethods()) {
                    this.scanMethod(method);
                }
            }
            for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
                this.scanMethod((Method)genericDeclaration);
            }
        }
    }

    Filters build() {
        return new Filters(this.beforeDispatchTriggers, this.htmlFilters, this.responseFilters, this.responseConverters, this.paramProcessors);
    }
}

