/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.geso.avans.Controller;
import me.geso.avans.Dispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvansServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AvansServlet.class);
    private final Dispatcher dispatcher = new Dispatcher();

    public void init(ServletConfig servletConfig) throws ServletException {
        String classCsv;
        super.init(servletConfig);
        String pkg = servletConfig.getInitParameter("package");
        if (pkg != null) {
            for (String p : pkg.split(",")) {
                LOGGER.info("Registering package: {}", (Object)p);
                this.registerPackage(p);
            }
        }
        if ((classCsv = servletConfig.getInitParameter("class")) != null) {
            for (String className : classCsv.split(",")) {
                LOGGER.info("Registering class: {}", (Object)className);
                try {
                    Class<?> klass = Class.forName(className);
                    this.registerClass(klass);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("AvansServlet can't load class: {}", (Object)className);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void registerPackage(String packageName) {
        this.dispatcher.registerPackage(packageName);
    }

    public void registerPackage(Package pkg) {
        this.dispatcher.registerPackage(pkg.getName());
    }

    public void registerClass(Class<? extends Controller> klass) {
        this.dispatcher.registerClass(klass);
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.dispatcher.handler((HttpServletRequest)req, (HttpServletResponse)res);
    }
}

