/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import me.geso.avans.JSONParamReader;

public interface JacksonJsonParamReader
extends JSONParamReader {
    @Override
    default public Object readJsonParam(InputStream is, Class<?> valueType) throws IOException {
        int n;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = is.read(buffer))) {
            output.write(buffer, 0, n);
        }
        byte[] byteArray = output.toByteArray();
        try {
            return mapper.readValue(byteArray, valueType);
        }
        catch (JsonParseException | JsonMappingException e) {
            String json = new String(byteArray, StandardCharsets.UTF_8);
            Throwable cause = e.getCause();
            String message = (cause != null ? cause.getMessage() : e.getMessage()) + " : " + json;
            throw new IOException(message, e);
        }
    }
}

