/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import me.geso.avans.Controller;
import me.geso.avans.JSONRendererProvider;
import me.geso.avans.jackson.CharacterEscapesAgainstXSS;
import me.geso.webscrew.response.ByteArrayResponse;
import me.geso.webscrew.response.WebResponse;

public interface JacksonJsonView
extends Controller,
JSONRendererProvider {
    @Override
    default public WebResponse renderJSON(int statusCode, Object obj) {
        byte[] json;
        try {
            json = _PrivateStaticFields._writer.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        ByteArrayResponse res = new ByteArrayResponse(statusCode, json);
        res.setContentType("application/json; charset=utf-8");
        res.setContentLength((long)json.length);
        return res;
    }

    default public WebResponse renderJSON(Object obj) {
        return this.renderJSON(200, obj);
    }

    default public ObjectMapper createObjectMapper() {
        return _PrivateStaticFields.createObjectMapper();
    }

    default public void setObjectWriter(ObjectWriter writer) {
        _PrivateStaticFields._writer = writer;
    }

    public static class _PrivateStaticFields {
        private static ObjectWriter _writer = _PrivateStaticFields.createObjectMapper().writer();

        private static ObjectMapper createObjectMapper() {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            mapper.getFactory().setCharacterEscapes((CharacterEscapes)new CharacterEscapesAgainstXSS());
            return mapper;
        }
    }
}

