/*
 * Decompiled with CFR 0.152.
 */
package me.geso.avans.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.geso.avans.JSONParamReader;

public interface JacksonJsonParamReader
extends JSONParamReader {
    @Override
    default public Object readJsonParam(InputStream is, Class<?> valueType) throws IOException {
        int n;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (-1 != (n = is.read(buffer))) {
            output.write(buffer, 0, n);
        }
        byte[] byteArray = output.toByteArray();
        try {
            ObjectReader reader = _PrivateStaticFields._readerMap.computeIfAbsent(valueType, key -> _PrivateStaticFields._reader.withType(key));
            return reader.readValue(byteArray);
        }
        catch (JsonParseException | JsonMappingException e) {
            String json = new String(byteArray, StandardCharsets.UTF_8);
            Throwable cause = e.getCause();
            String message = (cause != null ? cause.getMessage() : e.getMessage()) + " : " + json;
            throw new IOException(message, e);
        }
    }

    public static class _PrivateStaticFields {
        private static ObjectReader _reader = _PrivateStaticFields.createObjectReader();
        private static Map<Class<?>, ObjectReader> _readerMap = new ConcurrentHashMap();

        private static ObjectReader createObjectReader() {
            return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).reader();
        }
    }
}

