/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import me.geso.mech.JsonValidator;
import me.geso.mech.MechPostMultipartFormRequest;
import me.geso.mech.MechPostUrlEncodedFormRequest;
import me.geso.mech.MechRequest;
import me.geso.mech.MechRequestListener;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;

public class Mech
implements AutoCloseable {
    private String baseURL;
    private final HeaderGroup defaultHeaders = new HeaderGroup();
    private final HttpClientBuilder httpClientBuilder;
    private final CookieStore cookieStore = new BasicCookieStore();
    private List<MechRequestListener> requestListeners;
    private Optional<JsonValidator> jsonValidator = Optional.empty();

    public Mech() {
        this.httpClientBuilder = HttpClientBuilder.create();
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("best-match").build();
        this.httpClientBuilder.setDefaultRequestConfig(globalConfig);
        this.httpClientBuilder.setDefaultCookieStore(this.cookieStore);
    }

    public Mech(String baseURL) {
        this.baseURL = baseURL;
        this.httpClientBuilder = HttpClientBuilder.create();
        this.httpClientBuilder.setDefaultCookieStore(this.cookieStore);
        RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("best-match").build();
        this.httpClientBuilder.setDefaultRequestConfig(globalConfig);
    }

    public HttpClientBuilder getHttpClientBuilder() {
        return this.httpClientBuilder;
    }

    public void setHeader(String name, String value) {
        this.defaultHeaders.updateHeader((Header)new BasicHeader(name, value));
    }

    public void setUserAgent(String userAgent) {
        this.defaultHeaders.updateHeader((Header)new BasicHeader("User-Agent", userAgent));
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void addCookie(Cookie cookie) {
        this.getCookieStore().addCookie(cookie);
    }

    private URI makeURI(String pathQuery) {
        try {
            if (this.baseURL != null) {
                this.baseURL = this.baseURL.replaceFirst("/$", "");
                if (pathQuery.startsWith("/")) {
                    pathQuery = "/" + pathQuery;
                }
                URI url = new URI(this.baseURL + pathQuery);
                return url;
            }
            URI url = new URI(pathQuery);
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public MechRequest get(@NonNull String pathQuery) {
        if (pathQuery == null) {
            throw new NullPointerException("pathQuery");
        }
        try {
            URI url = this.makeURI(pathQuery);
            HttpGet get = new HttpGet(url);
            this.setDefaultHeaders((HttpRequestBase)get);
            return new MechRequest(this, (HttpRequestBase)get);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setDefaultHeaders(HttpRequestBase req) {
        HeaderIterator iterator = this.defaultHeaders.iterator();
        while (iterator.hasNext()) {
            Header header = iterator.nextHeader();
            req.addHeader(header);
        }
    }

    public Mech disableRedirectHandling() {
        this.getHttpClientBuilder().disableRedirectHandling();
        return this;
    }

    public Mech setRequestConfig(RequestConfig requestConfig) {
        this.getHttpClientBuilder().setDefaultRequestConfig(requestConfig);
        return this;
    }

    public <T> MechRequest postJSON(String path, T params) {
        if (params == null) {
            throw new RuntimeException("Params should not be null");
        }
        try {
            ObjectMapper mapper = this.createObjectMapper();
            byte[] json = mapper.writeValueAsBytes(params);
            URI url = this.makeURI(path);
            HttpPost post = new HttpPost(url);
            this.setDefaultHeaders((HttpRequestBase)post);
            post.setHeader("Content-Type", "application/json; charset=utf-8");
            post.setEntity((HttpEntity)new ByteArrayEntity(json));
            return new MechRequest(this, (HttpRequestBase)post);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        return mapper;
    }

    public <T> MechRequest post(String path, HttpEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Entity should not be null");
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            URI url = this.makeURI(path);
            HttpPost post = new HttpPost(url);
            this.setDefaultHeaders((HttpRequestBase)post);
            post.setEntity(entity);
            return new MechRequest(this, (HttpRequestBase)post);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> MechPostUrlEncodedFormRequest post(String path) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            URI url = this.makeURI(path);
            HttpPost post = new HttpPost(url);
            this.setDefaultHeaders((HttpRequestBase)post);
            return new MechPostUrlEncodedFormRequest(this, post);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> MechPostMultipartFormRequest postMultipart(String path) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
            URI url = this.makeURI(path);
            HttpPost post = new HttpPost(url);
            this.setDefaultHeaders((HttpRequestBase)post);
            return new MechPostMultipartFormRequest(this, post);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setProxy(HttpHost proxy) {
        this.httpClientBuilder.setProxy(proxy);
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public boolean hasRequestListener() {
        return this.requestListeners != null;
    }

    public void addRequestListener(MechRequestListener listener) {
        if (this.requestListeners == null) {
            this.requestListeners = new ArrayList<MechRequestListener>();
        }
        this.requestListeners.add(listener);
    }

    void callRequestListener(HttpRequestBase request, HttpResponse response) {
        if (this.requestListeners != null) {
            for (MechRequestListener listener : this.requestListeners) {
                listener.call((HttpRequest)request, response);
            }
        }
    }

    @Override
    public void close() throws Exception {
    }

    public Optional<JsonValidator> getJsonValidator() {
        return this.jsonValidator;
    }

    public void setJsonValidator(@NonNull JsonValidator jsonValidator) {
        if (jsonValidator == null) {
            throw new NullPointerException("jsonValidator");
        }
        this.jsonValidator = Optional.of(jsonValidator);
    }

    public void setJsonValidator(@NonNull Optional<JsonValidator> jsonValidator) {
        if (jsonValidator == null) {
            throw new NullPointerException("jsonValidator");
        }
        this.jsonValidator = jsonValidator;
    }
}

