/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech;

import javax.servlet.Servlet;
import me.geso.mech.Mech;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class MechJettyServlet
extends Mech
implements AutoCloseable {
    private Server server;

    public MechJettyServlet(Class<? extends Servlet> servlet) {
        ServletHolder servletHolder = new ServletHolder(servlet);
        this.initialize(servletHolder);
    }

    public MechJettyServlet(Servlet servlet) {
        ServletHolder servletHolder = new ServletHolder(servlet);
        this.initialize(servletHolder);
    }

    private void initialize(ServletHolder servletHolder) {
        try {
            this.server = this.createServer(servletHolder);
            this.server.start();
            ServerConnector connector = (ServerConnector)this.server.getConnectors()[0];
            int port = connector.getLocalPort();
            this.setBaseURL("http://127.0.0.1:" + port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Server createServer(ServletHolder servletHolder) {
        int port = 0;
        Server server = new Server(port);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/", 1);
        context.addServlet(servletHolder, "/*");
        server.setStopAtShutdown(true);
        return server;
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

