/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech;

import java.io.File;
import java.nio.charset.Charset;
import me.geso.mech.Mech;
import me.geso.mech.MechRequest;
import me.geso.mech.MechResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;

public class MechPostMultipartFormRequest {
    private final Mech testMech;
    private final HttpPost post;
    private MultipartEntityBuilder builder;
    private Charset charset;

    public MechPostMultipartFormRequest(Mech testMech, HttpPost post) {
        this.testMech = testMech;
        this.post = post;
        this.charset = Charset.forName("UTF-8");
        this.builder = MultipartEntityBuilder.create().setCharset(this.charset);
    }

    public MechPostMultipartFormRequest setCharset(Charset charset) {
        this.charset = charset;
        this.builder.setCharset(charset);
        return this;
    }

    public MechPostMultipartFormRequest param(String name, String text) {
        ContentType contentType = ContentType.create((String)"text/plain", (Charset)this.charset);
        this.builder.addTextBody(name, text, contentType);
        return this;
    }

    public MechPostMultipartFormRequest param(String name, byte[] b) {
        this.builder.addBinaryBody(name, b);
        return this;
    }

    public MechPostMultipartFormRequest file(String name, File file) {
        this.builder.addPart(name, (ContentBody)new FileBody(file));
        return this;
    }

    public MechResponse execute() {
        try {
            HttpEntity entity = this.builder.build();
            this.post.setEntity(entity);
            MechRequest request = new MechRequest(this.testMech, (HttpRequestBase)this.post);
            return request.execute();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

