/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech;

import java.io.IOException;
import me.geso.mech.Mech;
import me.geso.mech.MechResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;

public class MechRequest {
    private final HttpRequestBase request;
    private final Mech mech;

    public MechRequest(Mech mech, HttpRequestBase request) {
        this.request = request;
        this.mech = mech;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public MechRequest setHeader(String name, String value) {
        this.request.setHeader(name, value);
        return this;
    }

    public MechRequest addHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public MechResponse execute() {
        try {
            if (this.mech.hasRequestListener() && this.request instanceof HttpEntityEnclosingRequestBase) {
                HttpEntity entity = ((HttpEntityEnclosingRequestBase)this.request).getEntity();
                ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new BufferedHttpEntity(entity));
            }
            HttpClientContext context = HttpClientContext.create();
            context.setCookieStore(this.mech.getCookieStore());
            CloseableHttpClient httpclient = this.mech.getHttpClientBuilder().build();
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)this.request, (HttpContext)context);
            if (this.mech.hasRequestListener()) {
                HttpEntity entity = response.getEntity();
                response.setEntity((HttpEntity)new BufferedHttpEntity(entity));
            }
            this.mech.callRequestListener(this.request, (HttpResponse)response);
            return new MechResponse(this, httpclient, response, this.mech.getJsonValidator());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

